/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.input.setofvessels;

import java.util.List;

import javax.swing.DefaultListModel;

import fr.ifremer.isisfish.entities.Metier;

/**
 * Model pour la liste des metiers de l'interface SetOfVessels.
 *
 * @author chatellier
 * @version $Revision: 2398 $
 * 
 * Last update : $Date: 2009-06-17 15:00:12 +0200 (mer., 17 juin 2009) $
 * By : $Author: chatellier $
 */
public class MetierListModel extends DefaultListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2715181950778932871L;
    
    /** Listes des metiers */
    protected List<Metier> metiers;

    /**
     * Empty constructor.
     */
    public MetierListModel() {
        this(null);
    }

    /**
     * Constructor with metiers list.
     * 
     * @param metiers liste des metiers
     */
    public MetierListModel(List<Metier> metiers) {
        super();
        setMetiers(metiers);
    }

    /**
     * Get metiers list.
     * 
     * @return the metiers list
     */
    public List<Metier> getMetiers() {
        return metiers;
    }

    /**
     * Set metiers list.
     * 
     * @param metiers the metiers list to set
     */
    public void setMetiers(List<Metier> metiers) {
        this.metiers = metiers;
        fireContentsChanged(this, 0, getSize());
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return metiers.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (metiers != null) {
            size = metiers.size();
        }
        return size;
    }
}
