/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.input.gear;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Population;

/**
 * Model pour la liste des {@link Population}.
 * 
 * Pas de selection par defaut.
 *
 * @author chatellier
 * @version $Revision: 2729 $
 * 
 * Last update : $Date: 2009-11-02 17:27:43 +0100 (lun., 02 nov. 2009) $
 * By : $Author: chatellier $
 */
public class PopulationComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6171850179969290032L;

    /** Population list */
    protected List<Population> populations;

    /**
     * Constructor with species list.
     * 
     * @param populations populations list
     */
    public PopulationComboModel(List<Population> populations) {
        super();
        this.populations = populations;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return populations.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (populations != null) {
            size = populations.size();
        }
        return size;
    }
}
