/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.input.formule;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

import fr.ifremer.isisfish.entities.Formule;

/**
 * Model pour la liste des {@link Formule}.
 * 
 * Pas de selection par defaut.
 *
 * @author chatellier
 * @version $Revision: 2744 $
 * 
 * Last update : $Date: 2009-11-06 17:59:01 +0100 (ven., 06 nov. 2009) $
 * By : $Author: chatellier $
 */
public class FormuleComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6171850179969290032L;

    /** Formules list */
    protected List<Formule> formules;

    /**
     * Constructor with formules list.
     * 
     * @param formules formules list
     */
    public FormuleComboModel(List<Formule> formules) {
        super();
        this.formules = formules;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return formules.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (formules != null) {
            size = formules.size();
        }
        return size;
    }
}
