/* *##%
 * Copyright (C) 2002 - 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.input.check;

import javax.swing.table.DefaultTableCellRenderer;
import java.awt.Component;
import javax.swing.JTable;
import java.awt.Color;

/**
 * CheckResultTableRenderer.java
 *
 * Created: 10 janv. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 2105 $
 *
 * Mise a jour: $Date: 2009-04-14 15:55:22 +0200 (mar., 14 avril 2009) $
 * par : $Author: chatellier $
 */
public class CheckResultTableRenderer extends DefaultTableCellRenderer { // CheckResultTableRenderer
    /** serialVersionUID. */
    private static final long serialVersionUID = 8015604773747460458L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
                row, column);
        if (!isSelected) {
            if ("error".equals(table.getValueAt(row, 2))) {
                setBackground(Color.red);
            } else if ("warning".equals(table.getValueAt(row, 2))) {
                setBackground(Color.orange);
            } else if ("info".equals(table.getValueAt(row, 2))) {
                setBackground(Color.cyan);
            }
        }
        return this;
    }
} // CheckResultTableRenderer
