/* *##%
 * Copyright (C) 2002 - 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.input.check;

import static org.nuiton.i18n.I18n._;

import javax.swing.JFrame;
import javax.swing.WindowConstants;
import javax.swing.JScrollPane;
import javax.swing.JTable;

/**
 * CheckResultFrame.
 *
 * Created: 10 janv. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 2658 $
 *
 * Mise a jour: $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
 * par : $Author: chatellier $
 */
public class CheckResultFrame extends JFrame { // CheckResultFrame
    
    /** serialVersionUID. */
    private static final long serialVersionUID = -3425876562425941700L;
    
    protected CheckResultTableModel model;

    public CheckResultFrame(CheckResult checkResult) {
        this();
        setCheckResult(checkResult);
    }

    public CheckResultFrame() {
        super(_("isisfish.message.result.verif.region"));
        model = new CheckResultTableModel(new CheckResult());
        JTable table = new JTable(model);
        model.addMouseListenerToHeaderInTable(table);
        table.setDefaultRenderer(Object.class, new CheckResultTableRenderer());
        table.getColumnModel().getColumn(2).setPreferredWidth(30);

        this.setSize(600, 400);
        this.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
        this.getContentPane().add(new JScrollPane(table));
    }

    public void setCheckResult(CheckResult checkResult) {
        model.setCheckResult(checkResult);
    }

} // CheckResultFrame

