/* *##%
* Copyright (C) 2002 - 2009 Ifremer, Code Lutin
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Static public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Static public License for more details.
*
* You should have received a copy of the GNU General Static public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*##%*/

package fr.ifremer.isisfish.ui.input.check;

import static org.nuiton.i18n.I18n._;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.util.EvaluatorHelper;

/**
 * CheckSaisie.java
 *
 * Created: 9 janv. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 2995 $
 *
 * Mise a jour: $Date: 2010-02-23 12:27:15 +0100 (mar., 23 févr. 2010) $
 * par : $Author: chatellier $
 */
public class CheckRegion { // CheckSaisie
/*
        // check equation compilation
        for (Species species : fisheryRegion.getSpecies()) {
            for (Population pop : species.getPopulation()) {
                pop.getGrowth();
                pop.getGrowthReverse();
                pop.getMeanWeight();
                pop.getNaturalDeathRate();
                pop.getPrice();
                pop.getReproductionEquation();
                for (PopulationSeasonInfo info : pop.getPopulationSeasonInfo()) {
                    info.getMigrationEquation();
                    info.getEmigrationEquation();
                    info.getImmigrationEquation();
                }
            }
        }

 */
    
    static public void check(Object parent, String name, Equation eq, CheckResult result) {
        if (eq == null) {
            result.addError(parent, _("isisfish.error.invalid.nullequation", name));
        }
        else if (0 != EvaluatorHelper.check(eq.getJavaInterface(), eq.getContent(), null)) {
            result.addError(eq, _("isisfish.error.invalid.equation"));
        }
    }
    
    static public void check(TargetSpecies capturabilite, CheckResult result){
        check(capturabilite, "TargetFactorEquation", capturabilite.getTargetFactorEquation(), result);
    }

    static public void check(PopulationGroup classPop, CheckResult result){
        // error
        if(classPop.getMeanWeight() < 0){
            result.addError(classPop, _("isisfish.error.invalid.mean.weight"));
        }
        // if(classPop.getMortaliteNaturelle() < 0){
        //     result.addError(classPop, _("isisfish.error.invalidate.natural.death"));
        // }

        // warning
        if(classPop.getMeanWeight() == 0){
            result.addWarning(classPop, _("isisfish.error.not.null.mean.weight"));
        }
        // if(classPop.getMortaliteNaturelle() == 0){
        //     result.addWarning(classPop, _("isisfish.error.not.null.natural.death"));
        // }
    }

    static public void check(Gear engin, CheckResult result){
        if("".equals(engin.getName())){
            result.addWarning(engin, _("isisfish.error.empty.name"));
        }
        if("".equals(engin.getEffortUnit())){
            result.addWarning(engin, _("isisfish.error.empty.unit"));
        }
        
        Collection<Selectivity> selectivites = engin.getPopulationSelectivity();
        if(selectivites.size() == 0){
            result.addWarning(engin, _("isisfish.error.empty.selectivity"));
        }else{
            for(Selectivity selectivity : selectivites){
                check(selectivity, result);
            }
        }
        if(engin.getPossibleValue() == null){
            result.addWarning(engin, _("isisfish.error.invalid.range"));
        }

        if("".equals(engin.getParameterName())){
            result.addInfo(engin, _("isisfish.error.empty.params.name"));
        }
    }

    static public void check(MetierSeasonInfo infoSaisonMetier, CheckResult result){
        if(infoSaisonMetier.getZone() == null || infoSaisonMetier.getZone().size() == 0){
            result.addWarning(infoSaisonMetier, _("isisfish.error.no.sector"));
        }
        Collection<TargetSpecies> especeCaptus = infoSaisonMetier.getSpeciesTargetSpecies();
        if(especeCaptus.size() == 0){
            result.addInfo(infoSaisonMetier, _("isisfish.error.empty.species"));
        }else{
            for(TargetSpecies i :  especeCaptus){
                check(i, result);
            }
        }
    }

    static public boolean isEmptyMatrix(MatrixND mat) {
        boolean result = true;
        for (MatrixIterator i = mat.iterator(); result && i.next();) {
            result = false;
        }
        return result;
    }

    static public boolean isNullMatrix(MatrixND mat) {
        boolean result = true;
        if (mat != null) {
            for (MatrixIterator i = mat.iterator(); result && i.next();) {
                result = i.getValue() == 0;
            }
        }
        return result;
    }
    
    static public boolean isNegativeMatrix(MatrixND mat) {
        boolean result = true;
        for (MatrixIterator i = mat.iterator(); result && i.next();) {
            result = i.getValue() < 0;
        }
        return result;
    }
    
    static public double sumMatrix(MatrixND mat) {
        double result = 0;
        for (MatrixIterator i = mat.iterator(); i.next();) {
            result += i.getValue();
        }
        return result;
    }
    
    static public void check(PopulationSeasonInfo infoSaisonPop, CheckResult result){
        if (infoSaisonPop.getUseEquationMigration()) {
            check(infoSaisonPop, "MigrationEquation", infoSaisonPop.getMigrationEquation(), result);
            check(infoSaisonPop, "Emigration", infoSaisonPop.getEmigrationEquation(), result);
            check(infoSaisonPop, "ImmigrationEquation", infoSaisonPop.getImmigrationEquation(), result);
        } else {
            if (isEmptyMatrix(infoSaisonPop.getMigrationMatrix())) {
                result.addInfo(infoSaisonPop, _("isisfish.error.empty.migration"));
            } else if(isNullMatrix(infoSaisonPop.getMigrationMatrix())) {
                result.addInfo(infoSaisonPop, _("isisfish.error.empty.migration"));
            } else if(isNegativeMatrix(infoSaisonPop.getMigrationMatrix())) {
                result.addError(infoSaisonPop, _("isisfish.error.migration.negative"));
            }
            
            
            if (isEmptyMatrix(infoSaisonPop.getEmigrationMatrix())) {
                result.addInfo(infoSaisonPop, _("isisfish.error.empty.emigration"));
            } else if(isNullMatrix(infoSaisonPop.getEmigrationMatrix())) {
                result.addInfo(infoSaisonPop, _("isisfish.error.empty.emigration"));
            } else if(isNegativeMatrix(infoSaisonPop.getEmigrationMatrix())) {
                result.addError(infoSaisonPop, _("isisfish.error.emigration.negative"));
            }
            
            if (isEmptyMatrix(infoSaisonPop.getImmigrationMatrix())) {
                result.addInfo(infoSaisonPop, _("isisfish.error.empty.immigration"));
            } else if(isNullMatrix(infoSaisonPop.getImmigrationMatrix())) {
                result.addInfo(infoSaisonPop, _("isisfish.error.empty.immigration"));
            } else if(isNegativeMatrix(infoSaisonPop.getImmigrationMatrix())) {
                result.addError(infoSaisonPop, _("isisfish.error.immigration.negative"));
            }
        }
    }

    static public void check(Cell maille, CheckResult result){
        if("".equals(maille.getName())){
            result.addWarning(maille, _("isisfish.error.empty.name"));
        }
    }

    static public void check(Species metaPop, CheckResult result){
        Collection<Population> pops = metaPop.getPopulation();
        if(pops.size() == 0){
            result.addWarning(metaPop, _("isisfish.error.empty.population"));
        }else{
            for(Population pop : pops){
                check(pop, result);
            }
        }
        if("".equals(metaPop.getName())){
            result.addInfo(metaPop, _("isisfish.error.empty.species.name"));
        }
        if("".equals(metaPop.getScientificName())){
            result.addInfo(metaPop, _("isisfish.error.empty.scientific.name"));
        }
        if("".equals(metaPop.getCodeRubbin())){
            result.addInfo(metaPop, _("isisfish.error.empty.code.rubbin"));
        }
    }

    static public void check(Metier metier, CheckResult result){
        if("".equals(metier.getName())){
            result.addWarning(metier, _("isisfish.error.empty.name"));
        }
        List<MetierSeasonInfo> infoSaisons = metier.getMetierSeasonInfo();
        if(infoSaisons.size() == 0){
            result.addWarning(metier, _("isisfish.error.empty.season"));
        }else{
            Set<Month> months = new HashSet<Month>();
            for(MetierSeasonInfo info : infoSaisons){
                if (!Collections.disjoint(months, info.getMonths())) {
                    result.addError(info, _("isisfish.error.overlap.season"));
                }
                months.addAll(info.getMonths());
                check(info, result);
            }
        }
        if(metier.getGear() == null){
            result.addError(metier, _("isisfish.error.undefined.gear"));
        }else{
            check(metier.getGear(), result);
        }
        
        try {
            if (!metier.getGear().getPossibleValue().contains(metier.getGearParameterValue())) {
                result.addWarning(metier, _("isisfish.error.invalid.values.params"));
            }
        } catch(Exception e) {
            // can't happen StringIndexOutOfBoundsException
            // if gear.PossibleValue if not valid
            result.addWarning(metier, _("isisfish.error.invalid.values.params"));
        }
        
    }

    static public void check(Population pop, CheckResult result){
        if("".equals(pop.getName())){
            result.addWarning(pop, _("isisfish.error.empty.name"));
        }
        if("".equals(pop.getGeographicId())){
            result.addInfo(pop, _("isisfish.error.empty.id.geographic"));
        }
        if(pop.getMaturityGroup() == null){
            result.addInfo(pop, _("isisfish.error.not.null.class.grown"));
        }
        check(pop, "Growth", pop.getGrowth(), result);
        check(pop, "GrowthReverse", pop.getGrowthReverse(), result);
        List<PopulationGroup> classes = pop.getPopulationGroup();
        if(classes.size() == 0){
            result.addWarning(pop, _("isisfish.error.undefined.classes"));
        }else{
            for(PopulationGroup group : classes){
                check(group, result);
            }
        }
        // if(pop.getMortNatClasseNaissance() == 0){
        //     result.addInfo(pop, _("isisfish.error.undefined.natural.death"));
        // }
        // if(pop.getMortNatClasseNaissance() < 0){
        //     result.addWarning(pop, _("isisfish.error.invalid.natural.death"));
        // }
        if(pop.getMonthGapBetweenReproRecrutement() < 0){
            result.addWarning(pop, _("isisfish.error.invalid.interval.reproduction.recruitment"));
        }
        if (isNullMatrix(pop.getMappingZoneReproZoneRecru())) {
            result.addWarning(pop, _("isisfish.error.undefined.correspondence.zones.reproduction.recruitment"));
        }
        if(pop.getPopulationZone() == null || pop.getPopulationZone().size() == 0){
            result.addWarning(pop, _("isisfish.error.undefined.zone.population"));
        }
        if(pop.getRecruitmentZone() == null || pop.getRecruitmentZone().size() == 0){
            result.addWarning(pop, _("isisfish.error.undefined.zone.recruitment"));
        }
        if(pop.getReproductionZone() == null || pop.getReproductionZone().size() == 0){
            result.addWarning(pop, _("isisfish.error.undefined.zone.reproduction"));
        }
        List<PopulationSeasonInfo> infoSaisons = pop.getPopulationSeasonInfo();
        if(infoSaisons.size() == 0){
            result.addWarning(pop, _("isisfish.error.empty.season"));
        }else{
            Set<Month> months = new HashSet<Month>();
            for(PopulationSeasonInfo info : infoSaisons){
                if (!Collections.disjoint(months, info.getMonths())) {
                    result.addError(info, _("isisfish.error.overlap.season"));
                }
                months.addAll(info.getMonths());
                check(info, result);
            }
        }
        check(pop, "Price", pop.getPrice(), result);
        check(pop, "MeanWeight", pop.getMeanWeight(), result);
        check(pop, "ReproductionEquation", pop.getReproductionEquation(), result);
        check(pop, "NaturalDeathRate", pop.getNaturalDeathRate(), result);
        
        if (sumMatrix(pop.getRecruitmentDistribution()) != 1) {
            result.addWarning(pop, _("isisfish.error.invalid.distribution.recruitment"));
        }
    }

    static public void check(FisheryRegion region, CheckResult result){
        if("".equals(region.getName())){
            result.addWarning(region, _("isisfish.error.empty.name"));
        }
        
        List<Zone> secteurs = region.getZone();
        if(secteurs.size() == 0){
            result.addWarning(region, _("isisfish.error.undefined.sector"));
        }else{
            for(Zone zone : secteurs){
                check(zone, result);
            }
        }
        List<Cell> mailles = region.getCell();
        if(mailles.size() == 0){
            result.addWarning(region, _("isisfish.error.undefined.mesh"));
        }else{
            for(Cell cell : mailles){
                check(cell, result);
            }
        }
        List<Species> metaPops = region.getSpecies();
        if(metaPops.size() == 0){
            result.addWarning(region, _("isisfish.error.undefined.meta.population"));
        }else{
            for(Species species : metaPops){
                check(species, result);
            }
        }
        List<Metier> metiers = region.getMetier();
        if(metiers.size() == 0){
            result.addWarning(region, _("isisfish.error.undefined.meta.population"));
        }else{
            for(Metier metier : metiers){
                check(metier, result);
            }
        }
        List<Strategy> strategies = region.getStrategy();
        if(strategies.size() == 0){
            result.addWarning(region, _("isisfish.error.undefined.stategy"));
        }else{
            for(Strategy strategy : strategies){
                check(strategy, result);
            }
        }
    }

    static public void check(Zone secteur, CheckResult result){
        if("".equals(secteur.getName())){
            result.addWarning(secteur, _("isisfish.error.empty.name"));
        }
        if(secteur.getCell().size() == 0){
            result.addWarning(secteur, _("isisfish.error.undefined.mesh.sector"));
        }
    }

    static public void check(Selectivity selectivite, CheckResult result){

    }


    static public void check(Strategy strategy, CheckResult result){
        if("".equals(strategy.getName())){
            result.addWarning(strategy, _("isisfish.error.empty.name"));
        }
        check(strategy.getSetOfVessels(), result);
        
        List<StrategyMonthInfo> smi = strategy.getStrategyMonthInfo();
        if(smi.size() != 12){
            result.addWarning(strategy, _("isisfish.error.undefined.stategy.months"));
        }else{
            for(StrategyMonthInfo info : smi){
                check(info, result);
            }
        }

    }

    static public void check(SetOfVessels sov, CheckResult result){
        check(sov.getPort(), result);
        if(sov.getNumberOfVessels() < 0){
            result.addWarning(sov, _("isisfish.error.invalid.number"));
        }
        if(sov.getFixedCosts() < 0){
            result.addWarning(sov, _("isisfish.error.invalid.costs.fix"));
        }
        Collection<EffortDescription> efforts = sov.getPossibleMetiers();
        if(efforts.size() == 0){
            result.addWarning(sov, _("isisfish.error.not.possible.metier"));
        }else{
            for(EffortDescription effort : efforts) {
                check(effort, result);
            }
        }
    }
    
    // TODO check for VesselType, TripType, Port, StrategyMonthInfo
    static public void check(EffortDescription effort, CheckResult result){

    }
    static public void check(StrategyMonthInfo smi, CheckResult result){

    }
    static public void check(VesselType vesselType, CheckResult result){

    }
    static public void check(TripType tripType, CheckResult result){

    }
    static public void check(Port port, CheckResult result){

    }

} // CheckSaisie
