package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import javax.swing.event.ListSelectionEvent;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.entities.ZoneImpl;
import fr.ifremer.isisfish.map.CellSelectionLayer;
import fr.ifremer.isisfish.map.CopyMapToClipboardListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.gui.OMToolSet;

public class ZoneUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WQW8bRRSeuEncNKSkaZpWQCBQg5BAa6BAUVMV0kBURw6tkhRV9YWxdxxPGc8sM7PupgeExBWhnjhwAe4cuSPEkRNX/gNC/Qe8N17vep2tvZLJYdf75n3ffu/NvG/zyz9kzmjy8gMaRZ4OpeVd5u1u3bt3u/mAtezHzLQ0D6zSpP83UyKlBln0k7ix5HKjjvBqDK9uq26gJJND6M06OWPssWCmw5i15EIf0TKmepCEN6Mg1AO2REwe209P/i099r/+uURIFICqNShhYxIqrWC2Tkrct2QF3tSjVUHlEcjQXB6BziWMbQtqzKe0y74kX5FyncwHVAOZJa8UL9VxOHwUWLJcqckgtNtKWki/W3sL+tbWHm9r1mVwN9y0uel4Ifc4Jnr3gfduLQgcxbwls01GpSWv5oGAkVvOjAPVuoFIYecrB05YTUIGFfwR029b8pJrVgvUcwFEJ1LG4t/BpXPDypR/bMmlzAaYh9BO75A2BUszy6gPYpasYZejOGv3IBDc3qHStXs1Ta84/BV8XMPLxWTpdGW3TptMvAu7mKFyUUx6LsldanMmfHw17ujouw9ZZHcwIQsavOA9fH5xhLCyC01RQqDk9y25mC0mWcqiFh6Bgm0mBIzM8zm9wqmrc2MxvXJCx9VJOj7A4GvZhOWkcjioXXeAL5wofkszivlvphtqaA/6dD6TejO0Vsks/3yLyla/3VdGV4DVsrwVOLuql7dyqkuD0e3EykR268tWKbGHqetwgL1mU3oqYBLA3hFMzyGsJqhrKQq771C5Y4foGjxAxk2YsxirsQc4KMZ4qU+lRjLTIHM6hDC0upFa2j6E+mYWRx2Bi/74zQ+973/97drAuVbhHUuZlCGjBScJNNSmcbYtebZvV6Hlogo6NxtkwTABLu1ceHVIwEEcBhHAfw5hHsK8W9R0ADpX/vv3P9Y+/+sUKe2QM0JRf4difo0s2I6GKpXwo+DDj5ySZx6ehusyagINPu9xn+m6alHLwczIynUuBZdsg1qw0GZo2Y0IKl8dqjyR8+fjb/de+G796qD6mb66kbS0A3P3yXyf3Tl2bMa5Dr0YGBb6KjXdPBuewfulIDakW+5azytzVsbMt6MQb3ecWPy1X5hjBb1Oha3OJ1FApY9ONiXjotIchtg1fkqqMpMoCD6CZ6/71NKNJpc+TNyNfMr1Ij2zYCZjZE3mwLDrUTufYaMQwxdTM4zTcLm4hqf0oRjDOA2vF9iNs31rYP5nVITMTMU2Sc8bU/ekGMM4DdWpz8ZkBvh4CXqsQjuGZbMAyxJ+cpg+3mdH8SQ/hWyrCNlgo92/Fv8PGajaU/44u0Ky/wBCMlOlPAwAAA==";
    protected javax.swing.JSplitPane ZoneTab;
    protected fr.ifremer.isisfish.entities.ZoneImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JTextArea fieldZoneComment;
    protected javax.swing.JTextField fieldZoneName;
    protected javax.swing.JPanel map;
    protected javax.swing.JButton remove;
    protected javax.swing.JButton save;
    protected com.bbn.openmap.gui.ToolPanel toolMap;
    protected jaxx.runtime.swing.JAXXList zoneCells;
    protected fr.ifremer.isisfish.map.IsisMapBean zoneMap;
    private fr.ifremer.isisfish.ui.input.ZoneUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JScrollPane $JScrollPane6;
    private javax.swing.JScrollPane $JScrollPane8;
    private jaxx.runtime.swing.Table $Table3;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldZoneName.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldZoneName.text");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "zoneCells.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "zoneCells.selectedValues");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel7.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldZoneComment.enabled");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldZoneComment.text");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "zoneMap.fisheryRegion");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "zoneMap.selectedCells");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");

    /* begin raw body code */
    protected OMToolSet toolSet;
    protected OpenMapEvents mapListener;
    
    
    @Override
    public void refresh() {
        Zone zone = getVerifier().getEntity(Zone.class);
    
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((ZoneImpl) zone);
    
        // reload region in map
        refreshRegionInMap(zoneMap);
    
        if (getBean() != null) {
            setZoneCells();
            zoneMap.setSelectedCells(getBean().getCell());
        }
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
        getVerifier().setNewButton(create, "Zone");
        getVerifier().setDeleteButton(remove);
    }
    
    protected void setZoneCells(){
        if (getBean() != null){
            DefaultListModel model = new DefaultListModel();
            for (Cell c : getRegion().getCell())
                model.addElement(c);
            zoneCells.setModel(model);
            if (getBean().getCell() != null){
                zoneCells.setSelectedValues(getBean().getCell().toArray());
            }
        }
    }
    protected OpenMapEvents getMapListener() {
        if (mapListener == null) {
            jaxx.runtime.Util.assignment(mapListener = new OpenMapEvents(zoneMap, new SelectMouseMode(false), CellSelectionLayer.MULT_SELECTION) {
                @Override
                public boolean mouseClicked(MouseEvent e) {
                    getBean().setCell(zoneMap.getSelectedCells());
                    if (getBean().getCell() != null){
                        zoneCells.setSelectedValues(getBean().getCell().toArray());
                    }
                    return true;
                }
            }, "mapListener", fr.ifremer.isisfish.ui.input.ZoneUI.this);
        }
        return mapListener;
    }
    
    protected void zoneCellsChange(ListSelectionEvent event) {
        // sans ca, ca boucle (modification depuis la carte)
        if (event.getValueIsAdjusting()) {
            // pas a faie dans le cas d'une AS
            if (isActif()) {
                java.util.List<Cell> cells = new ArrayList<Cell>();
                for (Object o : zoneCells.getSelectedValues()) {
                    cells.add((Cell) o);
                }
                getBean().setCell(cells);
            }
        }
        else {
            if (log.isDebugEnabled()) {
                log.debug("Duplicated event skipped");
            }
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ZoneUI() {
        super();
        $initialize();
    }

    public ZoneUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldZoneName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldZoneName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource11);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("name", $DataSource11);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("zoneCells.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else if ("zoneCells.selectedValues".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource14);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("cell", $DataSource14);
            }if ( getBean() != null) {
                 getBean().addPropertyChangeListener("cell", $DataSource14);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldZoneComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource16);
            }
        } else if ("fieldZoneComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource17);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("comment", $DataSource17);
            }
        } else if ("zoneMap.fisheryRegion".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("region", $DataSource19);
            }
        } else if ("zoneMap.selectedCells".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource20);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("cell", $DataSource20);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldZoneName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldZoneName.setEnabled((isActif()));
            }
            } else if ("fieldZoneName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldZoneName, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getName()))));
            }
            } else if ("$JLabel5.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel5.setEnabled((isActif()));
            }
            } else if ("zoneCells.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                zoneCells.setEnabled((isActif()));
            }
            } else if ("zoneCells.selectedValues".equals($dest)) {
            if ( getBean() != null) {
                zoneCells.setSelectedValues((getBean().getCell() == null ? null : getBean().getCell().toArray()));
            }
            } else if ("$JLabel7.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel7.setEnabled((isActif()));
            }
            } else if ("fieldZoneComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldZoneComment.setEnabled((isActif()));
            }
            } else if ("fieldZoneComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldZoneComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()))));
            }
            } else if ("zoneMap.fisheryRegion".equals($dest)) {
            if ($InputContentUI0 != null) {
                zoneMap.setFisheryRegion((getRegion()));
            }
            } else if ("zoneMap.selectedCells".equals($dest)) {
            if (getBean() != null) {
                zoneMap.setSelectedCells((getBean().getCell()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldZoneName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldZoneName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource11);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("name", $DataSource11);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("zoneCells.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else if ("zoneCells.selectedValues".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource14);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("cell", $DataSource14);
            }if ( getBean() != null) {
                 getBean().removePropertyChangeListener("cell", $DataSource14);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldZoneComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource16);
            }
        } else if ("fieldZoneComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource17);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("comment", $DataSource17);
            }
        } else if ("zoneMap.fisheryRegion".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("region", $DataSource19);
            }
        } else if ("zoneMap.selectedCells".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource20);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("cell", $DataSource20);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doKeyReleased__on__fieldZoneComment(java.awt.event.KeyEvent event) {
        getBean().setComment(fieldZoneComment.getText());
    }

    public void doKeyReleased__on__fieldZoneName(java.awt.event.KeyEvent event) {
        getBean().setName(fieldZoneName.getText());
    }

    public void doValueChanged__on__zoneCells(javax.swing.event.ListSelectionEvent event) {
        zoneCellsChange(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.ZoneImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JTextArea getFieldZoneComment() {
        return fieldZoneComment;
    }

    public javax.swing.JTextField getFieldZoneName() {
        return fieldZoneName;
    }

    public javax.swing.JPanel getMap() {
        return map;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public com.bbn.openmap.gui.ToolPanel getToolMap() {
        return toolMap;
    }

    public jaxx.runtime.swing.JAXXList getZoneCells() {
        return zoneCells;
    }

    public fr.ifremer.isisfish.map.IsisMapBean getZoneMap() {
        return zoneMap;
    }

    public javax.swing.JSplitPane getZoneTab() {
        return ZoneTab;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.ZoneImpl newValue) {
        fr.ifremer.isisfish.entities.ZoneImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setToolMap(com.bbn.openmap.gui.ToolPanel newValue) {
        com.bbn.openmap.gui.ToolPanel oldValue = this.toolMap;
        this.toolMap = newValue;
        firePropertyChange("toolMap", oldValue, newValue);
    }

    public void setZoneMap(fr.ifremer.isisfish.map.IsisMapBean newValue) {
        fr.ifremer.isisfish.map.IsisMapBean oldValue = this.zoneMap;
        this.zoneMap = newValue;
        firePropertyChange("zoneMap", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.ZoneUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected javax.swing.JScrollPane get$JScrollPane8() {
        return $JScrollPane8;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        
        
        addChildrenToBody();
        addChildrenToZoneTab();
        $Table3.add($JLabel4, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldZoneName), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel5, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JScrollPane6, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel7, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JScrollPane8, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(1, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        $JScrollPane6.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(zoneCells));
        
        
        $JScrollPane8.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldZoneComment));
        
        addChildrenToMap();
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldZoneName.enabled");
        applyDataBinding("fieldZoneName.text");
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("zoneCells.enabled");
        applyDataBinding("zoneCells.selectedValues");
        applyDataBinding("$JLabel7.enabled");
        applyDataBinding("fieldZoneComment.enabled");
        applyDataBinding("fieldZoneComment.text");
        applyDataBinding("zoneMap.fisheryRegion");
        applyDataBinding("zoneMap.selectedCells");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        toolSet = new OMToolSet();
        
        mapListener = null;
        
        createZoneTab();
        
        $Table3 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table3", $Table3);
        $Table3.setName("$Table3");
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.zone.name"));
        
        createFieldZoneName();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.zone.cells"));
        
        $JScrollPane6 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane6", $JScrollPane6);
        $JScrollPane6.setName("$JScrollPane6");
        
        createZoneCells();
        
        $JLabel7 = new javax.swing.JLabel();
        $objectMap.put("$JLabel7", $JLabel7);
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.zone.comments"));
        
        $JScrollPane8 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane8", $JScrollPane8);
        $JScrollPane8.setName("$JScrollPane8");
        
        createFieldZoneComment();
        createSave();
        createCancel();
        createCreate();
        createRemove();
        createMap();
        createToolMap();
        createZoneMap();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        toolSet.setupListeners(zoneMap);toolMap.add((Tool)toolSet);// add copy to clipboard support
        zoneMap.addMapMouseListener(new CopyMapToClipboardListener(zoneMap));zoneMap.addMapMouseListener(getMapListener());setButtonTitle(_("isisfish.input.continuePorts"));setNextPath("$root/$ports");addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("bean changed " + evt.getOldValue() + " : " + evt.getNewValue());
                }
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldZoneName.setText("");
                    fieldZoneComment.setText("");
                    zoneMap.setSelectedCells((Cell)null);
                }
                if (evt.getNewValue() != null) {
        
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(ZoneTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMap() {
        if (!allComponentsCreated) {
            return;
        }
        map.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(toolMap), BorderLayout.NORTH);
        map.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(zoneMap), BorderLayout.CENTER);
    }

    protected void addChildrenToZoneTab() {
        if (!allComponentsCreated) {
            return;
        }
        ZoneTab.add($Table3, JSplitPane.LEFT);
        ZoneTab.add(map, JSplitPane.RIGHT);
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
    }

    protected void createFieldZoneComment() {
        fieldZoneComment = new javax.swing.JTextArea();
        $objectMap.put("fieldZoneComment", fieldZoneComment);
        fieldZoneComment.setName("fieldZoneComment");
        fieldZoneComment.setColumns(15);
        fieldZoneComment.setLineWrap(true);
        fieldZoneComment.setWrapStyleWord(true);
        fieldZoneComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldZoneComment"));
    }

    protected void createFieldZoneName() {
        fieldZoneName = new javax.swing.JTextField();
        $objectMap.put("fieldZoneName", fieldZoneName);
        fieldZoneName.setName("fieldZoneName");
        fieldZoneName.setColumns(15);
        fieldZoneName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldZoneName"));
    }

    protected void createMap() {
        map = new javax.swing.JPanel();
        $objectMap.put("map", map);
        map.setName("map");
        map.setLayout((new BorderLayout()));
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

    protected void createToolMap() {
        toolMap = new com.bbn.openmap.gui.ToolPanel();
        $objectMap.put("toolMap", toolMap);
        toolMap.setName("toolMap");
    }

    protected void createZoneCells() {
        zoneCells = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("zoneCells", zoneCells);
        zoneCells.setName("zoneCells");
        zoneCells.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $InputContentUI0, "doValueChanged__on__zoneCells"));
    }

    protected void createZoneMap() {
        zoneMap = new fr.ifremer.isisfish.map.IsisMapBean();
        $objectMap.put("zoneMap", zoneMap);
        zoneMap.setName("zoneMap");
        zoneMap.setSelectionMode(2);
    }

    protected void createZoneTab() {
        ZoneTab = new javax.swing.JSplitPane();
        $objectMap.put("ZoneTab", ZoneTab);
        ZoneTab.setName("ZoneTab");
        ZoneTab.setDividerLocation(200);
        ZoneTab.setName("Zones");
        ZoneTab.setOneTouchExpandable(true);
        ZoneTab.setOrientation(1);
    }

}
