package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import fr.ifremer.isisfish.ui.widget.Interval;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationSeasonsUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WzXMbNRRXTOKkH4FCAnT6QRPwcIB2nUK/aDLQxiXgjBM6ccKEmkNlr2yryCshaZ1NDwwzvTJMTxy4AHeO3BmGIyeu/A8Mw3/Ak9b2eu3FXmbxQd59eu+n30/vSW9//BPNKYlWH+EgcKTvadohzvbdw8OP6o9IQ98jqiGp0Fyi8DeTQ7kaOuUO7Eqj12oVE17shRdLvCO4R7yh6PUKOqn0MSOqTYjW6MUwoqFUsTowrwfCl320AZkktO///iv31P3yhxxCgQBW50DCyrSoSMFsBeWoq9ELsFIXFxn2WkBDUq8FPBeNrcSwUru4Qz5HX6D5CsoLLAFMo1fTS7UYNj4QGp0plD3h6xL3NLgflNc0WmtKhzYl6RD4V1Q1qWo7PnWocXTuc+EzrCn3qgQr7qmDshAWL6/RbJ1gT6M3kxAAnmpK1BBCuSNYFLwsRqDLXpNrdD0lWBQzDhvN7XK96zOm0fNmPx2zx84m5wx4RyFLhardtbIHi2BGHxN5VaNLNpMN2FrKgMuYy/A2cPdYo7Ox1KsjSKSzj+uMRJ7zBWt4y7yeM8PZwdRCYbuC64S9DQVhuAY9hNBqnM4PfFealDA3aS9Kbc4VkX32cTLmQEGp1PkmD+KA/cWvmfdL8bkl1UPXRHYxu489wv4l51A1R9RtEe3EvMfWstbro0ITfJOFfiC5L0ptyCWBMxzDKLVJ47MxeRdHS60qSCNMo3tQ1uj2fzoCVYGj4GRtN8z7G/G51UQte0RI7voNYzGOV5ITczMhMVemAt6jCu6Tum+eNbrMZcvxfKq553SwbptB0sBpgdId+2i5v++Ch0ymcSuBxmJhG84GZzbX72j0ciwh0VQ86kIieajOjr3g4lndJ4G+Kwk2sRtDpOxhurqWcJpmFe5CcSzFYDZ9rcNd3hw45hvYa4RltzU6AytqkjQDlcK7sRlpljLXhVJO1Eqiu36mhuakD2a4gmtR19kDU9hvelYLYK3fPfm2+81PP9/uN5fzsMZizGWoF8JlD1kXcPCpWeK5sKNA3llxB4v1GjqhCINGahvl8hCBas8MJAA/vCRNmPMhVm0InZv/45dfX3r4+zMot4VOMo7dLWz8y+iEbktQyZkbiPfuWCanjxZgPGM4wVVHPJMd6G/PbrhY45U69VxIw7sBqF0eUjug8NvTr3YufH3xZl/xTMhoxC1SPfcA5anHqEdsI+31yMTGeUoo4rs86oVJ3XHG/L8ierf1nh0/TpI2q6Ee4fbaCFdfwTo8ZQS0maAHlrx5+jQlpjEfmuGTZITVzAiFVAgPzYCzIEzi8HpmhMspsrMQljpxM+FM2400TOa70EzgDGQUdBq3iG15+8diElYxTemaL7aMGIlfWP8D5tjHTCbMaaV0LRXC48wIk4ooHcIkFTcyc0iH8CQzh0kqbqWokHz4tZIJZZqSdAiTlKxnzkc6hEkc7qTnMAHhH1jCcDSTDwAA";
    protected fr.ifremer.isisfish.entities.PopulationImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JTextArea fieldPopulationSeasonComment;
    protected javax.swing.JCheckBox fieldPopulationSeasonGroupChange;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationSeasonInfoChooser;
    protected javax.swing.JCheckBox fieldPopulationSeasonReproduction;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor fieldPopulationSeasonReproductionDistribution;
    protected java.lang.Boolean popSeasonInfoNotNull;
    protected fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl populationSeasonInfo;
    protected fr.ifremer.isisfish.ui.input.PopulationSeasonSpacializedUI populationSeasonSpecializedUI;
    protected javax.swing.JButton remove;
    protected javax.swing.JButton save;
    protected fr.ifremer.isisfish.ui.widget.IntervalPanel seasonIntervalPanel;
    private fr.ifremer.isisfish.ui.input.PopulationSeasonsUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JPanel $JPanel5;
    private javax.swing.JPanel $JPanel6;
    private javax.swing.JScrollPane $JScrollPane9;
    private jaxx.runtime.swing.Table $Table10;
    private jaxx.runtime.swing.Table $Table2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonInfoChooser.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "seasonIntervalPanel.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonGroupChange.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonGroupChange.selected");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonGroupChange.visible");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationSeasonSpecializedUI.ageGroupType");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationSeasonSpecializedUI.bean");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationSeasonSpecializedUI.popSeasonInfoNotNull");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationSeasonSpecializedUI.populationSeasonInfo");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonReproduction.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonReproduction.selected");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel7.enabled");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel7.visible");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonReproductionDistribution.enabled");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonReproductionDistribution.matrix");
    private java.beans.PropertyChangeListener $DataSource28 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonReproductionDistribution.visible");
    private java.beans.PropertyChangeListener $DataSource29 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel8.enabled");
    private java.beans.PropertyChangeListener $DataSource30 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonComment.enabled");
    private java.beans.PropertyChangeListener $DataSource31 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationSeasonComment.text");

    /* begin raw body code */
    //protected MatrixPanelListener matrixPanelListener;
    protected Interval seasonInterval;
    protected boolean init;
    
    
    /*matrixPanelListener = new MatrixPanelListener() {
        @Override
        public void matrixChanged(MatrixPanelEvent event) {
            if (getPopulationSeasonInfo() != null && fieldPopulationSeasonReproductionDistribution.getMatrix() != null) {
                MatrixND reproductionDistribution = fieldPopulationSeasonReproductionDistribution.getMatrix().copy();
                if (log.isDebugEnabled()) {
                    log.debug("Matrix ReproductionDistribution modified : " + reproductionDistribution);
                }
                getPopulationSeasonInfo().setReproductionDistribution(reproductionDistribution);
            }
        }
    };*/
    
    protected void populationSeasonReproductionDistributionMatrixChanged(MatrixPanelEvent event) {
        if (getPopulationSeasonInfo() != null && fieldPopulationSeasonReproductionDistribution.getMatrix() != null) {
            MatrixND reproductionDistribution = fieldPopulationSeasonReproductionDistribution.getMatrix().copy();
            if (log.isDebugEnabled()) {
                log.debug("Matrix ReproductionDistribution modified : " + reproductionDistribution);
            }
            getPopulationSeasonInfo().setReproductionDistribution(reproductionDistribution);
        }
    }
    
    @Override
    public void refresh() {
        if (!isActif()) {
            setPopSeasonInfoNotNull(false);
        }
    
        Population population = getVerifier().getEntity(Population.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((PopulationImpl) population);
    
        // Model instanciation
        seasonInterval = new Interval();
        seasonInterval.setMin(0);
        seasonInterval.setMax(11);
        seasonInterval.setFirst(0);
        seasonInterval.setLast(2);
    
        setPopulationSeasonInfoCombo();
        setSeasonInterval();
    
        seasonIntervalPanel.setLabelRenderer(Month.MONTH);
        seasonIntervalPanel.setModel(seasonInterval);
    
        //fieldPopulationSeasonReproductionDistribution.addMatrixListener(matrixPanelListener);
    
        if(getPopulationSeasonInfo() != null) {
            PopulationSeasonInfoImpl popInfo = getPopulationSeasonInfo();
            setPopulationSeasonInfo(null);
            setPopulationSeasonInfo(popInfo);
            getVerifier().addCurrentEntity(getPopulationSeasonInfo());
        }
        getVerifier().addCurrentPanel(populationSeasonSpecializedUI);
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save, false);
        getVerifier().setCancelButton(cancel);
        getVerifier().setNewButton(create, "PopulationSeasonInfo", false);
        getVerifier().setDeleteButton(remove, false);
    }
    
    protected void setSeasonInterval() {
        if(getPopulationSeasonInfo() != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Updating interval : ");
                }
                Month firstMonth = getPopulationSeasonInfo().getFirstMonth();
    
                if (firstMonth != null) {
                    seasonInterval.setFirst(firstMonth.getMonthNumber());
                    
                    if (log.isDebugEnabled()) {
                        log.debug(" first : " + seasonInterval.getFirst());
                    }
                } else {
                    seasonInterval.setFirst(0);
                }
    
                Month lastMonth = getPopulationSeasonInfo().getLastMonth();
                if (lastMonth != null) {
                    seasonInterval.setLast(lastMonth.getMonthNumber());
                    if (log.isDebugEnabled()) {
                        log.debug(" last : " + seasonInterval.getLast());
                    }
                } else {
                    seasonInterval.setLast(3);
                }
            } catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("Can't display interval", e);
                }
            }
        }
    }
    
    protected void setPopulationSeasonInfoCombo() {
        if (getBean() != null) {
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationSeasonInfoChooser,
                getBean().getPopulationSeasonInfo(), getPopulationSeasonInfo(), true);
        }
    }
    
    protected void seasonGroupChanged() {
        if (getPopulationSeasonInfo() != null) {
           getPopulationSeasonInfo().setGroupChange(fieldPopulationSeasonGroupChange.isSelected());
        }
    }
    
    protected void seasonChanged() {
        jaxx.runtime.Util.assignment(init = true, "init", fr.ifremer.isisfish.ui.input.PopulationSeasonsUI.this);
        PopulationSeasonInfo seasonInfoSelected = (PopulationSeasonInfo)fieldPopulationSeasonInfoChooser.getSelectedItem();
        if (log.isDebugEnabled()) {
            log.debug("Season changed : " + seasonInfoSelected);
        }
        setPopulationSeasonInfo((PopulationSeasonInfoImpl)seasonInfoSelected);
        setPopSeasonInfoNotNull(getPopulationSeasonInfo() != null);
        setSeasonInterval();
        setReproductionDistributionMatrix();
        getVerifier().addCurrentEntity(getPopulationSeasonInfo());
        jaxx.runtime.Util.assignment(init = false, "init", fr.ifremer.isisfish.ui.input.PopulationSeasonsUI.this);
    }
    
    protected void setReproductionDistributionMatrix() {
        if (getPopulationSeasonInfo() != null){
            MatrixND reproductionDistribution = getPopulationSeasonInfo().getReproductionDistribution();
            // must be a copy (otherwise, modify current entity matrix)
            if (reproductionDistribution != null){
                fieldPopulationSeasonReproductionDistribution.setMatrix(reproductionDistribution.copy());
            }
        }
    }
    
    // TODO une methode isXXX ne prend pas de parametre
    // et ne fait rien
    protected boolean isAgeGroupType(boolean result) {
        populationSeasonSpecializedUI.setVisible(result);
        return result;
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationSeasonsUI() {
        super();
        $initialize();
    }

    public PopulationSeasonsUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPopulationSeasonInfoChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource13);
        
        } else if ("seasonIntervalPanel.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource14);
        
        } else if ("fieldPopulationSeasonGroupChange.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource15);
        
        } else if ("fieldPopulationSeasonGroupChange.selected".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource16);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().addPropertyChangeListener("groupChange", $DataSource16);
            }
        } else if ("fieldPopulationSeasonGroupChange.visible".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource17);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().addPropertyChangeListener("population", $DataSource17);
            }
        } else if ("populationSeasonSpecializedUI.ageGroupType".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource18);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().addPropertyChangeListener("population", $DataSource18);
            }
        } else if ("populationSeasonSpecializedUI.bean".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource19);
        
        } else if ("populationSeasonSpecializedUI.popSeasonInfoNotNull".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource20);
        
        } else if ("populationSeasonSpecializedUI.populationSeasonInfo".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource21);
        
        } else if ("fieldPopulationSeasonReproduction.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource22);
        
        } else if ("fieldPopulationSeasonReproduction.selected".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource23);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().addPropertyChangeListener("reproduction", $DataSource23);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource24);
        
        } else if ("$JLabel7.visible".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource25);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().addPropertyChangeListener("reproduction", $DataSource25);
            }
        } else if ("fieldPopulationSeasonReproductionDistribution.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource26);
        
        } else if ("fieldPopulationSeasonReproductionDistribution.matrix".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource27);
        if ( getPopulationSeasonInfo() != null) {
                 getPopulationSeasonInfo().addPropertyChangeListener("reproductionDistribution", $DataSource27);
            }
        } else if ("fieldPopulationSeasonReproductionDistribution.visible".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource28);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().addPropertyChangeListener("reproduction", $DataSource28);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource29);
        
        } else if ("fieldPopulationSeasonComment.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource30);
        
        } else if ("fieldPopulationSeasonComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource31);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("seasonsComment", $DataSource31);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldPopulationSeasonInfoChooser.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationSeasonInfoChooser.setEnabled((isActif()));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            $JLabel4.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("seasonIntervalPanel.enabled".equals($dest)) {
            seasonIntervalPanel.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("fieldPopulationSeasonGroupChange.enabled".equals($dest)) {
            fieldPopulationSeasonGroupChange.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("fieldPopulationSeasonGroupChange.selected".equals($dest)) {
            if (getPopulationSeasonInfo() != null) {
                fieldPopulationSeasonGroupChange.setSelected((getPopulationSeasonInfo().getGroupChange()));
            }
            } else if ("fieldPopulationSeasonGroupChange.visible".equals($dest)) {
            if (getPopulationSeasonInfo() != null) {
                fieldPopulationSeasonGroupChange.setVisible((isAgeGroupType(getPopulationSeasonInfo().getPopulation().getSpecies().getAgeGroupType())));
            }
            } else if ("populationSeasonSpecializedUI.ageGroupType".equals($dest)) {
            if (getPopulationSeasonInfo() != null) {
                populationSeasonSpecializedUI.setAgeGroupType((isAgeGroupType(!getPopulationSeasonInfo().getPopulation().getSpecies().getAgeGroupType())));
            }
            } else if ("populationSeasonSpecializedUI.bean".equals($dest)) {
            populationSeasonSpecializedUI.setBean((getBean()));
            } else if ("populationSeasonSpecializedUI.popSeasonInfoNotNull".equals($dest)) {
            populationSeasonSpecializedUI.setPopSeasonInfoNotNull((isPopSeasonInfoNotNull()));
            } else if ("populationSeasonSpecializedUI.populationSeasonInfo".equals($dest)) {
            populationSeasonSpecializedUI.setPopulationSeasonInfo((getPopulationSeasonInfo()));
            } else if ("fieldPopulationSeasonReproduction.enabled".equals($dest)) {
            fieldPopulationSeasonReproduction.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("fieldPopulationSeasonReproduction.selected".equals($dest)) {
            if (getPopulationSeasonInfo() != null) {
                fieldPopulationSeasonReproduction.setSelected((getPopulationSeasonInfo().getReproduction()));
            }
            } else if ("$JLabel7.enabled".equals($dest)) {
            $JLabel7.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("$JLabel7.visible".equals($dest)) {
            if (getPopulationSeasonInfo() != null) {
                $JLabel7.setVisible((getPopulationSeasonInfo().getReproduction()));
            }
            } else if ("fieldPopulationSeasonReproductionDistribution.enabled".equals($dest)) {
            fieldPopulationSeasonReproductionDistribution.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("fieldPopulationSeasonReproductionDistribution.matrix".equals($dest)) {
            if ( getPopulationSeasonInfo() != null) {
                fieldPopulationSeasonReproductionDistribution.setMatrix((getPopulationSeasonInfo() == null ? null : getPopulationSeasonInfo().getReproductionDistribution().copy()));
            }
            } else if ("fieldPopulationSeasonReproductionDistribution.visible".equals($dest)) {
            if (getPopulationSeasonInfo() != null) {
                fieldPopulationSeasonReproductionDistribution.setVisible((getPopulationSeasonInfo().getReproduction()));
            }
            } else if ("$JLabel8.enabled".equals($dest)) {
            $JLabel8.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("fieldPopulationSeasonComment.enabled".equals($dest)) {
            fieldPopulationSeasonComment.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("fieldPopulationSeasonComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationSeasonComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getSeasonsComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPopulationSeasonInfoChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource13);
        
        } else if ("seasonIntervalPanel.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource14);
        
        } else if ("fieldPopulationSeasonGroupChange.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource15);
        
        } else if ("fieldPopulationSeasonGroupChange.selected".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource16);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().removePropertyChangeListener("groupChange", $DataSource16);
            }
        } else if ("fieldPopulationSeasonGroupChange.visible".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource17);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().removePropertyChangeListener("population", $DataSource17);
            }
        } else if ("populationSeasonSpecializedUI.ageGroupType".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource18);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().removePropertyChangeListener("population", $DataSource18);
            }
        } else if ("populationSeasonSpecializedUI.bean".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource19);
        
        } else if ("populationSeasonSpecializedUI.popSeasonInfoNotNull".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource20);
        
        } else if ("populationSeasonSpecializedUI.populationSeasonInfo".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource21);
        
        } else if ("fieldPopulationSeasonReproduction.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource22);
        
        } else if ("fieldPopulationSeasonReproduction.selected".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource23);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().removePropertyChangeListener("reproduction", $DataSource23);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource24);
        
        } else if ("$JLabel7.visible".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource25);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().removePropertyChangeListener("reproduction", $DataSource25);
            }
        } else if ("fieldPopulationSeasonReproductionDistribution.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource26);
        
        } else if ("fieldPopulationSeasonReproductionDistribution.matrix".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource27);
        if ( getPopulationSeasonInfo() != null) {
                 getPopulationSeasonInfo().removePropertyChangeListener("reproductionDistribution", $DataSource27);
            }
        } else if ("fieldPopulationSeasonReproductionDistribution.visible".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource28);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().removePropertyChangeListener("reproduction", $DataSource28);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource29);
        
        } else if ("fieldPopulationSeasonComment.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource30);
        
        } else if ("fieldPopulationSeasonComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource31);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("seasonsComment", $DataSource31);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__fieldPopulationSeasonGroupChange(java.awt.event.ActionEvent event) {
        seasonGroupChanged();
    }

    public void doActionPerformed__on__fieldPopulationSeasonInfoChooser(java.awt.event.ActionEvent event) {
        seasonChanged();
    }

    public void doActionPerformed__on__fieldPopulationSeasonReproduction(java.awt.event.ActionEvent event) {
        getPopulationSeasonInfo().setReproduction(fieldPopulationSeasonReproduction.isSelected());
    }

    public void doKeyReleased__on__fieldPopulationSeasonComment(java.awt.event.KeyEvent event) {
        getBean().setSeasonsComment(fieldPopulationSeasonComment.getText());
    }

    public void doMatrixChanged__on__fieldPopulationSeasonReproductionDistribution(org.nuiton.math.matrix.gui.MatrixPanelEvent event) {
        populationSeasonReproductionDistributionMatrixChanged(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.PopulationImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JTextArea getFieldPopulationSeasonComment() {
        return fieldPopulationSeasonComment;
    }

    public javax.swing.JCheckBox getFieldPopulationSeasonGroupChange() {
        return fieldPopulationSeasonGroupChange;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationSeasonInfoChooser() {
        return fieldPopulationSeasonInfoChooser;
    }

    public javax.swing.JCheckBox getFieldPopulationSeasonReproduction() {
        return fieldPopulationSeasonReproduction;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getFieldPopulationSeasonReproductionDistribution() {
        return fieldPopulationSeasonReproductionDistribution;
    }

    public java.lang.Boolean getPopSeasonInfoNotNull() {
        return popSeasonInfoNotNull;
    }

    public fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl getPopulationSeasonInfo() {
        return populationSeasonInfo;
    }

    public fr.ifremer.isisfish.ui.input.PopulationSeasonSpacializedUI getPopulationSeasonSpecializedUI() {
        return populationSeasonSpecializedUI;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public fr.ifremer.isisfish.ui.widget.IntervalPanel getSeasonIntervalPanel() {
        return seasonIntervalPanel;
    }

    public java.lang.Boolean isPopSeasonInfoNotNull() {
        return popSeasonInfoNotNull !=null && popSeasonInfoNotNull;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setPopSeasonInfoNotNull(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popSeasonInfoNotNull;
        this.popSeasonInfoNotNull = newValue;
        firePropertyChange("popSeasonInfoNotNull", oldValue, newValue);
    }

    public void setPopulationSeasonInfo(fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl oldValue = this.populationSeasonInfo;
        this.populationSeasonInfo = newValue;
        firePropertyChange("populationSeasonInfo", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationSeasonsUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected javax.swing.JPanel get$JPanel6() {
        return $JPanel6;
    }

    protected javax.swing.JScrollPane get$JScrollPane9() {
        return $JScrollPane9;
    }

    protected jaxx.runtime.swing.Table get$Table10() {
        return $Table10;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        
        addChildrenToBody();
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(fieldPopulationSeasonInfoChooser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(seasonIntervalPanel), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JPanel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonGroupChange), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(populationSeasonSpecializedUI, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.6, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JPanel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(fieldPopulationSeasonReproduction, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel7, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonReproductionDistribution), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.2, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel8, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane9, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        addChildrenToFieldPopulationSeasonGroupChange();
        
        
        addChildrenToFieldPopulationSeasonReproductionDistribution();
        
        $JScrollPane9.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonComment));
        
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldPopulationSeasonInfoChooser.enabled");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("seasonIntervalPanel.enabled");
        applyDataBinding("fieldPopulationSeasonGroupChange.enabled");
        applyDataBinding("fieldPopulationSeasonGroupChange.selected");
        applyDataBinding("fieldPopulationSeasonGroupChange.visible");
        applyDataBinding("populationSeasonSpecializedUI.ageGroupType");
        applyDataBinding("populationSeasonSpecializedUI.bean");
        applyDataBinding("populationSeasonSpecializedUI.popSeasonInfoNotNull");
        applyDataBinding("populationSeasonSpecializedUI.populationSeasonInfo");
        applyDataBinding("fieldPopulationSeasonReproduction.enabled");
        applyDataBinding("fieldPopulationSeasonReproduction.selected");
        applyDataBinding("$JLabel7.enabled");
        applyDataBinding("$JLabel7.visible");
        applyDataBinding("fieldPopulationSeasonReproductionDistribution.enabled");
        applyDataBinding("fieldPopulationSeasonReproductionDistribution.matrix");
        applyDataBinding("fieldPopulationSeasonReproductionDistribution.visible");
        applyDataBinding("$JLabel8.enabled");
        applyDataBinding("fieldPopulationSeasonComment.enabled");
        applyDataBinding("fieldPopulationSeasonComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createPopulationSeasonInfo();
        createPopSeasonInfoNotNull();
        
        init = false;
        
        $Table2 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table2", $Table2);
        $Table2.setName("$Table2");
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationSeasons.selectSeason"));
        
        createFieldPopulationSeasonInfoChooser();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.common.season"));
        
        createSeasonIntervalPanel();
        
        $JPanel5 = new javax.swing.JPanel();
        $objectMap.put("$JPanel5", $JPanel5);
        $JPanel5.setName("$JPanel5");
        
        createFieldPopulationSeasonGroupChange();
        createPopulationSeasonSpecializedUI();
        
        $JPanel6 = new javax.swing.JPanel();
        $objectMap.put("$JPanel6", $JPanel6);
        $JPanel6.setName("$JPanel6");
        
        createFieldPopulationSeasonReproduction();
        
        $JLabel7 = new javax.swing.JLabel();
        $objectMap.put("$JLabel7", $JLabel7);
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.populationSeasons.distributionSpawning"));
        
        createFieldPopulationSeasonReproductionDistribution();
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.populationSeasons.comments"));
        
        $JScrollPane9 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane9", $JScrollPane9);
        $JScrollPane9.setName("$JScrollPane9");
        
        createFieldPopulationSeasonComment();
        
        $Table10 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table10", $Table10);
        $Table10.setName("$Table10");
        
        createSave();
        createCancel();
        createCreate();
        createRemove();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        /*
         * Don't add both in same listener.
         * When first is set, last value from getPopulationSeasonInfo()
         * is erased by interval.getLast() default value.
         */
        seasonIntervalPanel.addPropertyChangeListener("first", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().setFirstMonth(new Month(seasonInterval.getFirst()));
                    setReproductionDistributionMatrix();
                }
            }
        });seasonIntervalPanel.addPropertyChangeListener("last", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().setLastMonth(new Month(seasonInterval.getLast()));
                    setReproductionDistributionMatrix();
                }
            }
        });addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldPopulationSeasonComment.setText("");
                    fieldPopulationSeasonReproductionDistribution.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                
                }
            }
        });create.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationSeasonInfo seasonNew = getContextValue(InputAction.class).createPopulationSeasonInfo(getBean());
                setPopulationSeasonInfo((PopulationSeasonInfoImpl)seasonNew);
                setPopulationSeasonInfoCombo();
            }
        });remove.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                getContextValue(InputAction.class).removePopulationSeasonInfo(getBean(), getPopulationSeasonInfo());
                setPopulationSeasonInfoCombo();
            }
        });save.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                getVerifier().topiaSave();
                setPopulationSeasonInfoCombo();
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table10, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldPopulationSeasonGroupChange() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationSeasonGroupChange.putClientProperty("bean", PopulationSeasonInfoImpl.class);
        fieldPopulationSeasonGroupChange.putClientProperty("method", "GroupChange");
    }

    protected void addChildrenToFieldPopulationSeasonReproductionDistribution() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationSeasonReproductionDistribution.putClientProperty("bean", PopulationSeasonInfoImpl.class);
        fieldPopulationSeasonReproductionDistribution.putClientProperty("method", "ReproductionDistribution");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
    }

    protected void createFieldPopulationSeasonComment() {
        fieldPopulationSeasonComment = new javax.swing.JTextArea();
        $objectMap.put("fieldPopulationSeasonComment", fieldPopulationSeasonComment);
        fieldPopulationSeasonComment.setName("fieldPopulationSeasonComment");
        fieldPopulationSeasonComment.setColumns(15);
        fieldPopulationSeasonComment.setLineWrap(true);
        fieldPopulationSeasonComment.setWrapStyleWord(true);
        fieldPopulationSeasonComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationSeasonComment"));
    }

    protected void createFieldPopulationSeasonGroupChange() {
        fieldPopulationSeasonGroupChange = new javax.swing.JCheckBox();
        $objectMap.put("fieldPopulationSeasonGroupChange", fieldPopulationSeasonGroupChange);
        fieldPopulationSeasonGroupChange.setName("fieldPopulationSeasonGroupChange");
        fieldPopulationSeasonGroupChange.setText(_("isisfish.populationSeasons.changeGroup"));
        fieldPopulationSeasonGroupChange.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationSeasonGroupChange"));
    }

    protected void createFieldPopulationSeasonInfoChooser() {
        fieldPopulationSeasonInfoChooser = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationSeasonInfoChooser", fieldPopulationSeasonInfoChooser);
        fieldPopulationSeasonInfoChooser.setName("fieldPopulationSeasonInfoChooser");
        fieldPopulationSeasonInfoChooser.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationSeasonInfoChooser"));
    }

    protected void createFieldPopulationSeasonReproduction() {
        fieldPopulationSeasonReproduction = new javax.swing.JCheckBox();
        $objectMap.put("fieldPopulationSeasonReproduction", fieldPopulationSeasonReproduction);
        fieldPopulationSeasonReproduction.setName("fieldPopulationSeasonReproduction");
        fieldPopulationSeasonReproduction.setText(_("isisfish.populationSeasons.Reproduction"));
        fieldPopulationSeasonReproduction.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationSeasonReproduction"));
    }

    protected void createFieldPopulationSeasonReproductionDistribution() {
        fieldPopulationSeasonReproductionDistribution = new org.nuiton.math.matrix.gui.MatrixPanelEditor();
        $objectMap.put("fieldPopulationSeasonReproductionDistribution", fieldPopulationSeasonReproductionDistribution);
        fieldPopulationSeasonReproductionDistribution.removeDataBinding("$MatrixEditor0.name");
        
        fieldPopulationSeasonReproductionDistribution.setName("fieldPopulationSeasonReproductionDistribution");
        fieldPopulationSeasonReproductionDistribution.removeDataBinding("$MatrixEditor0.enabled");
        
        fieldPopulationSeasonReproductionDistribution.removeDataBinding("$MatrixEditor0.matrix");
        
        fieldPopulationSeasonReproductionDistribution.removeDataBinding("$MatrixEditor0.visible");
        
        
        
        
        
        
        
        
        
        
        
        
        fieldPopulationSeasonReproductionDistribution.addMatrixPanelListener((org.nuiton.math.matrix.gui.MatrixPanelListener) jaxx.runtime.Util.getEventListener(org.nuiton.math.matrix.gui.MatrixPanelListener.class, "matrixChanged", $InputContentUI0, "doMatrixChanged__on__fieldPopulationSeasonReproductionDistribution"));
    }

    protected void createPopSeasonInfoNotNull() {
        popSeasonInfoNotNull = false;
        $objectMap.put("popSeasonInfoNotNull", popSeasonInfoNotNull);
    }

    protected void createPopulationSeasonInfo() {
        populationSeasonInfo = null;
        $objectMap.put("populationSeasonInfo", populationSeasonInfo);
    }

    protected void createPopulationSeasonSpecializedUI() {
        populationSeasonSpecializedUI = new fr.ifremer.isisfish.ui.input.PopulationSeasonSpacializedUI();
        $objectMap.put("populationSeasonSpecializedUI", populationSeasonSpecializedUI);
        populationSeasonSpecializedUI.removeDataBinding("$InputContentUI0.name");
        
        populationSeasonSpecializedUI.setName("populationSeasonSpecializedUI");
        populationSeasonSpecializedUI.removeDataBinding("$InputContentUI0.ageGroupType");
        
        populationSeasonSpecializedUI.removeDataBinding("$InputContentUI0.bean");
        
        populationSeasonSpecializedUI.removeDataBinding("$InputContentUI0.popSeasonInfoNotNull");
        
        populationSeasonSpecializedUI.removeDataBinding("$InputContentUI0.populationSeasonInfo");
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

    protected void createSeasonIntervalPanel() {
        seasonIntervalPanel = new fr.ifremer.isisfish.ui.widget.IntervalPanel();
        $objectMap.put("seasonIntervalPanel", seasonIntervalPanel);
        seasonIntervalPanel.setName("seasonIntervalPanel");
    }

}
