package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import javax.swing.table.DefaultTableModel;
import org.nuiton.topia.persistence.TopiaEntity;

public class PopulationBasicsUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJybOj7Zp0pK0hbY0IeGHQKwDLf1BCiVxSevIoVaTlKiWgPHu2J6y3tnOzCabHhASV4R64sAFuPfIjQMgxAUOiCv/A0L8B7zZtXe9zrBeaXNY2zPzPvN9b968t3nyNyoKjhYeYN83uOdI2iHGxuru7p3GA2LKm0SYnLqScRT+jRRQoY6OWtG4kGixXlXmpa55qcw6LnOI02e9UkVHhDywiWgTIiWaCy1MIUpb0fCK73q8R4vE6Gjf/vtP4bH12XcFhHwXVJ0FF+aHWcUejFZRgVoSnYSd9nDJxk4LZHDqtEDnlBor21iI93GHPESfovEqGnMxB5hEz2d3NWAE9r4r0cxSxXE9WWaOhOU7lWWJSk1u0CYnHQKfgoomFW3DowZVC40acz0bS8qcNSyoKXYqrhvgxiQabRDsSPSqDgB0KikRfYBKx7X7jZl1INGZRLzEPnhvbOOGTeKV40vBwOvq5wn1mB6ceiOaOhlNTSxtVHGD2BchwCqWfhcejqpFs9HaZ5qU2NagqyrwEp1KGG8TX66rxUlAb7NL6veZ5NyCFn6LsBbHbpualZtq4Vk98E0N8Dm92kZw0kRoaIsNT0rmDJqUOcGSdM0kejrh6Vpgold1WaNqXqtqE0uPh1tIdEFz1uqSQ/o22Brzs7hZsz1xizMPcnkuobfcJuYnhyDHpcqP1RapEqcl24O5EGTPgEWLs33Zfu+hF+w67H4E1+mOQ3rrdypJ3FyIu0v2CBfRKjV5SR/bK5rYTi1tbJmc2XYNO+SqRKcTTsRTSatz2gBCsDtBDZk7lNirkA/K9trg/bqmuXoT3Vu5HM3diO+2wHuBmBfVYzUaHzOxY4aX79BMkIu6GYg8S9K4SlXIJKjbRly348I6UkdF7tkqp2fqcYm/C0Nhce+OBoBg9JvPv9776vsf3+pV8pdgj6nEkr7GA5XV5cwlXNU3iabD8u1Japc2sbtSR5OC2NC1gq402ydgqzsMIoB/QpkZysy4jUUbTIvjf/38y6mP/3wKFdbREZthax2r9RU0KdscvGS25bs33g2UHNufgOeM0gTnRBx1GNBMjl+3sMTzDepYcK7v+ODtbJ+3kYTfH3+xee7L81d6Ho+EigaWxV4X76Mx6tjUIUHX6jYkbZc66griWSxuPLpWNKI+T7vdKl8Lnts610YlZCbc2+vh7vNYQouEekbAN2W0G4hX3+5nZKrhe+rxgZ7wbCbCh7kJaRrOZ9fwUR5CmoYLueOQjZCmYSF3HIYToJYRi8peK/gfzmJuX7IR0uKZX8MLueOZjZCm4eXcGrIR0jS8kpvwWpa8ChsBsXJxhkUjG+FeCmE5gy+T8B5zm9BWW+YEFaGn0WZKRC5m6QrqX4+cjGOKUQs7+UGKU1lYRdPGjx7lFDTdZLwD7xpleBNqMZ5P07CsyUb4IcWly5kIP+Um/JriRTbCb7k1/JFbQ9pZZCOkVaOruTVkI6RpeDt3f1OE/wDegE1FCxIAAA==";
    protected fr.ifremer.isisfish.entities.PopulationImpl bean;
    protected javax.swing.JButton buttonPopulationBasicsCreateClasses;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JTextArea fieldPopulationBasicsComment;
    protected javax.swing.JTextField fieldPopulationBasicsGeographicID;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationBasicsMatureClass;
    protected javax.swing.JTextField fieldPopulationBasicsName;
    protected javax.swing.JTextField fieldPopulationBasicsNbClasses;
    protected javax.swing.JCheckBox fieldPopulationBasicsPlusGroup;
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI growthEquation;
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI growthReverseEquation;
    protected javax.swing.JButton remove;
    protected javax.swing.JButton save;
    protected javax.swing.JTable tableAgeLength;
    private fr.ifremer.isisfish.ui.input.PopulationBasicsUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JScrollPane $JScrollPane8;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table10;
    private jaxx.runtime.swing.Table $Table2;
    private jaxx.runtime.swing.Table $Table9;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsName.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsName.text");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsGeographicID.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsGeographicID.text");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsNbClasses.enabled");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsNbClasses.text");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "buttonPopulationBasicsCreateClasses.enabled");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel6.enabled");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsMatureClass.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsPlusGroup.enabled");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsPlusGroup.selected");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "growthEquation.actif");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($InputContentUI0, "growthEquation.bean");
    private java.beans.PropertyChangeListener $DataSource28 = new jaxx.runtime.DataBindingListener($InputContentUI0, "growthReverseEquation.actif");
    private java.beans.PropertyChangeListener $DataSource29 = new jaxx.runtime.DataBindingListener($InputContentUI0, "growthReverseEquation.bean");
    private java.beans.PropertyChangeListener $DataSource31 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel7.enabled");
    private java.beans.PropertyChangeListener $DataSource32 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsComment.enabled");
    private java.beans.PropertyChangeListener $DataSource33 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationBasicsComment.text");

    /* begin raw body code */    
    
    @Override
    public void refresh() {
        Population population = getVerifier().getEntity(Population.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((PopulationImpl) population);
        
        if (getBean() != null) {
            if (getBean().getPopulationGroup() != null) {
                jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationBasicsMatureClass, getBean().getPopulationGroup(), getBean().getMaturityGroup(), true);
            }
            setTableAgeLengthModel();
        }
        getVerifier().addCurrentPanel(growthEquation, growthReverseEquation);
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
        getVerifier().setNewButton(create, "Population", false);
        getVerifier().setDeleteButton(remove);
    }
    
    /**
     * Open creation classe wizard after confirmation.
     */
    protected void createGroups() {
    
        int response = JOptionPane.showConfirmDialog(this, _("isisfish.populationBasics.confirmCreateGroups"),
            _("isisfish.common.confirm"), JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        
        if (response == JOptionPane.YES_OPTION) {
            JFrame wizardFrame = new JFrame();
            wizardFrame.setLayout(new BorderLayout());
            WizardGroupCreationUI wizard = new WizardGroupCreationUI(this);
            wizard.init(this);
            wizardFrame.add(wizard, BorderLayout.CENTER);
            wizardFrame.setTitle(_("isisfish.wizardGroupCreation.title"));
            wizard.setAgeType(getBean().getSpecies().getAgeGroupType());
            if (wizard.isAgeType()) {
                wizard.setCard("singleGroupAge");
            } else {
                wizard.setCard("beginGroupLength");
            }
            wizardFrame.pack();
            wizardFrame.setLocationRelativeTo(this);
            wizardFrame.setVisible(true);
            //refresh();
        }
       
    }
    protected void matureClassChanged(){
        Object selected = fieldPopulationBasicsMatureClass.getSelectedItem();
        if (getBean() != null){
            getBean().setMaturityGroup((PopulationGroup) selected);
        }
    }
    protected void setTableAgeLengthModel(){
        java.util.List<PopulationGroup> popGroup = getBean().getPopulationGroup();
        if (popGroup != null){
            DefaultTableModel model = new DefaultTableModel(2, popGroup.size() + 1);
            model.setValueAt("Age", 0, 0);
            model.setValueAt("Lengths", 1, 0);
            int cnt = 1;
            for (PopulationGroup pg : popGroup){
                model.setValueAt(pg.getAge(), 0, cnt);
                model.setValueAt(pg.getLength(), 1, cnt);
                cnt++;
            }
            tableAgeLength.setModel(model);
        }
    }
    protected void create(){
        Species species = getAction().getSpeciesByTopiaId(getVerifier().getIsisContext(), getVerifier().getCurrentNode().getParent().getNavigationPath());
        if (species == null){
            species = getAction().getSpeciesByTopiaId(getVerifier().getIsisContext(), getVerifier().getCurrentNode().getParent().getParent().getNavigationPath());
        }
    
        TopiaEntity topia = getContextValue(InputAction.class).createPopulation(getVerifier().getIsisContext(), species);
        getParentContainer(InputUI.class).setTreeModel();
        getParentContainer(InputUI.class).setTreeSelection("$root/$species/"+ species.getTopiaId() +"/$populations/"+topia.getTopiaId());
        setInfoText(_("isisfish.message.creation.finished"));
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationBasicsUI() {
        super();
        $initialize();
    }

    public PopulationBasicsUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPopulationBasicsName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("fieldPopulationBasicsName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource13);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("name", $DataSource13);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldPopulationBasicsGeographicID.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldPopulationBasicsGeographicID.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource16);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("geographicId", $DataSource16);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldPopulationBasicsNbClasses.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldPopulationBasicsNbClasses.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource19);
        
        } else if ("buttonPopulationBasicsCreateClasses.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource20);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldPopulationBasicsMatureClass.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource22);
            }
        } else if ("fieldPopulationBasicsPlusGroup.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource23);
            }
        } else if ("fieldPopulationBasicsPlusGroup.selected".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource24);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("plusGroup", $DataSource24);
            }
        } else if ("growthEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource25);
            }
        } else if ("growthEquation.bean".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource26);
        
        } else if ("growthReverseEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource28);
            }
        } else if ("growthReverseEquation.bean".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource29);
        
        } else if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource31);
            }
        } else if ("fieldPopulationBasicsComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource32);
            }
        } else if ("fieldPopulationBasicsComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource33);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("comment", $DataSource33);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationBasicsName.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationBasicsName, String.valueOf((getBean().getName())));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsGeographicID.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationBasicsGeographicID.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsGeographicID.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationBasicsGeographicID, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getGeographicId()))));
            }
            } else if ("$JLabel5.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel5.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsNbClasses.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationBasicsNbClasses.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsNbClasses.text".equals($dest)) {
            jaxx.runtime.SwingUtil.setText(fieldPopulationBasicsNbClasses, String.valueOf((getBean() == null ? "" : getBean().sizePopulationGroup())));
            } else if ("buttonPopulationBasicsCreateClasses.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                buttonPopulationBasicsCreateClasses.setEnabled((isActif()));
            }
            } else if ("$JLabel6.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel6.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsMatureClass.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationBasicsMatureClass.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsPlusGroup.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationBasicsPlusGroup.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsPlusGroup.selected".equals($dest)) {
            if (getBean() != null) {
                fieldPopulationBasicsPlusGroup.setSelected((getBean().getPlusGroup()));
            }
            } else if ("growthEquation.actif".equals($dest)) {
            if ($InputContentUI0 != null) {
                growthEquation.setActif((isActif()));
            }
            } else if ("growthEquation.bean".equals($dest)) {
            growthEquation.setBean((getBean()));
            } else if ("growthReverseEquation.actif".equals($dest)) {
            if ($InputContentUI0 != null) {
                growthReverseEquation.setActif((isActif()));
            }
            } else if ("growthReverseEquation.bean".equals($dest)) {
            growthReverseEquation.setBean((getBean()));
            } else if ("$JLabel7.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel7.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationBasicsComment.setEnabled((isActif()));
            }
            } else if ("fieldPopulationBasicsComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationBasicsComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPopulationBasicsName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("fieldPopulationBasicsName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource13);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("name", $DataSource13);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldPopulationBasicsGeographicID.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldPopulationBasicsGeographicID.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource16);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("geographicId", $DataSource16);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldPopulationBasicsNbClasses.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldPopulationBasicsNbClasses.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource19);
        
        } else if ("buttonPopulationBasicsCreateClasses.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource20);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldPopulationBasicsMatureClass.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource22);
            }
        } else if ("fieldPopulationBasicsPlusGroup.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource23);
            }
        } else if ("fieldPopulationBasicsPlusGroup.selected".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource24);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("plusGroup", $DataSource24);
            }
        } else if ("growthEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource25);
            }
        } else if ("growthEquation.bean".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource26);
        
        } else if ("growthReverseEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource28);
            }
        } else if ("growthReverseEquation.bean".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource29);
        
        } else if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource31);
            }
        } else if ("fieldPopulationBasicsComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource32);
            }
        } else if ("fieldPopulationBasicsComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource33);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("comment", $DataSource33);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonPopulationBasicsCreateClasses(java.awt.event.ActionEvent event) {
        createGroups();
    }

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        create();
    }

    public void doActionPerformed__on__fieldPopulationBasicsMatureClass(java.awt.event.ActionEvent event) {
        matureClassChanged();
    }

    public void doActionPerformed__on__fieldPopulationBasicsPlusGroup(java.awt.event.ActionEvent event) {
        getBean().setPlusGroup(fieldPopulationBasicsPlusGroup.isSelected());
    }

    public void doKeyReleased__on__fieldPopulationBasicsComment(java.awt.event.KeyEvent event) {
        getBean().setComment(fieldPopulationBasicsComment.getText());
    }

    public void doKeyReleased__on__fieldPopulationBasicsGeographicID(java.awt.event.KeyEvent event) {
        getBean().setGeographicId(fieldPopulationBasicsGeographicID.getText());
    }

    public void doKeyReleased__on__fieldPopulationBasicsName(java.awt.event.KeyEvent event) {
        getBean().setName(fieldPopulationBasicsName.getText());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.PopulationImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getButtonPopulationBasicsCreateClasses() {
        return buttonPopulationBasicsCreateClasses;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JTextArea getFieldPopulationBasicsComment() {
        return fieldPopulationBasicsComment;
    }

    public javax.swing.JTextField getFieldPopulationBasicsGeographicID() {
        return fieldPopulationBasicsGeographicID;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationBasicsMatureClass() {
        return fieldPopulationBasicsMatureClass;
    }

    public javax.swing.JTextField getFieldPopulationBasicsName() {
        return fieldPopulationBasicsName;
    }

    public javax.swing.JTextField getFieldPopulationBasicsNbClasses() {
        return fieldPopulationBasicsNbClasses;
    }

    public javax.swing.JCheckBox getFieldPopulationBasicsPlusGroup() {
        return fieldPopulationBasicsPlusGroup;
    }

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getGrowthEquation() {
        return growthEquation;
    }

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getGrowthReverseEquation() {
        return growthReverseEquation;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public javax.swing.JTable getTableAgeLength() {
        return tableAgeLength;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationBasicsUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JScrollPane get$JScrollPane8() {
        return $JScrollPane8;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table10() {
        return $Table10;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected jaxx.runtime.swing.Table get$Table9() {
        return $Table9;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        $Table1.add($Table2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsName), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsGeographicID), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsNbClasses), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(buttonPopulationBasicsCreateClasses), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel6, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsMatureClass), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsPlusGroup), new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(tableAgeLength), new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(growthEquation), new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(growthReverseEquation), new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel7, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane8, new GridBagConstraints(1, 7, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        
        addChildrenToFieldPopulationBasicsPlusGroup();
        addChildrenToGrowthEquation();
        addChildrenToGrowthReverseEquation();
        
        $JScrollPane8.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsComment));
        
        $Table9.add($Table10, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldPopulationBasicsName.enabled");
        applyDataBinding("fieldPopulationBasicsName.text");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldPopulationBasicsGeographicID.enabled");
        applyDataBinding("fieldPopulationBasicsGeographicID.text");
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("fieldPopulationBasicsNbClasses.enabled");
        applyDataBinding("fieldPopulationBasicsNbClasses.text");
        applyDataBinding("buttonPopulationBasicsCreateClasses.enabled");
        applyDataBinding("$JLabel6.enabled");
        applyDataBinding("fieldPopulationBasicsMatureClass.enabled");
        applyDataBinding("fieldPopulationBasicsPlusGroup.enabled");
        applyDataBinding("fieldPopulationBasicsPlusGroup.selected");
        applyDataBinding("growthEquation.actif");
        applyDataBinding("growthEquation.bean");
        growthEquation.setClazz((fr.ifremer.isisfish.equation.PopulationGrowth.class));
        applyDataBinding("growthReverseEquation.actif");
        applyDataBinding("growthReverseEquation.bean");
        growthReverseEquation.setClazz((fr.ifremer.isisfish.equation.PopulationGrowthReverse.class));
        applyDataBinding("$JLabel7.enabled");
        applyDataBinding("fieldPopulationBasicsComment.enabled");
        applyDataBinding("fieldPopulationBasicsComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $Table2 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table2", $Table2);
        $Table2.setName("$Table2");
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationBasics.name"));
        
        createFieldPopulationBasicsName();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.populationBasics.geographicID"));
        
        createFieldPopulationBasicsGeographicID();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.populationBasics.numberGroup"));
        
        createFieldPopulationBasicsNbClasses();
        createButtonPopulationBasicsCreateClasses();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.populationBasics.maturityGroup"));
        
        createFieldPopulationBasicsMatureClass();
        createFieldPopulationBasicsPlusGroup();
        createTableAgeLength();
        createGrowthEquation();
        createGrowthReverseEquation();
        
        $JLabel7 = new javax.swing.JLabel();
        $objectMap.put("$JLabel7", $JLabel7);
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.population.comments"));
        
        $JScrollPane8 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane8", $JScrollPane8);
        $JScrollPane8.setName("$JScrollPane8");
        
        createFieldPopulationBasicsComment();
        
        $Table9 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table9", $Table9);
        $Table9.setName("$Table9");
        
        $Table10 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table10", $Table10);
        $Table10.setName("$Table10");
        
        createSave();
        createCancel();
        createCreate();
        createRemove();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    // remove previous binding on getBean()
                    //jaxx.runtime.SwingUtil.removeDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text");fieldPopulationBasicsName.setText("");
                    fieldPopulationBasicsName.setText("");
                    fieldPopulationBasicsGeographicID.setText("");
                    fieldPopulationBasicsNbClasses.setText("");
                    fieldPopulationBasicsComment.setText("");
                    fieldPopulationBasicsMatureClass.setSelectedItem(null);
                    tableAgeLength.setModel(new DefaultTableModel());
                }
                if (evt.getNewValue() != null) {
                    // add binding on getBean()
                    //jaxx.runtime.SwingUtil.applyDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text")
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table9, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldPopulationBasicsPlusGroup() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationBasicsPlusGroup.putClientProperty("bean", PopulationImpl.class);
        fieldPopulationBasicsPlusGroup.putClientProperty("method", "PlusGroup");
    }

    protected void addChildrenToGrowthEquation() {
        if (!allComponentsCreated) {
            return;
        }
        growthEquation.putClientProperty("bean", PopulationImpl.class);
        growthEquation.putClientProperty("method", "Growth");
    }

    protected void addChildrenToGrowthReverseEquation() {
        if (!allComponentsCreated) {
            return;
        }
        growthReverseEquation.putClientProperty("bean", PopulationImpl.class);
        growthReverseEquation.putClientProperty("method", "GrowthReverse");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createButtonPopulationBasicsCreateClasses() {
        buttonPopulationBasicsCreateClasses = new javax.swing.JButton();
        $objectMap.put("buttonPopulationBasicsCreateClasses", buttonPopulationBasicsCreateClasses);
        buttonPopulationBasicsCreateClasses.setName("buttonPopulationBasicsCreateClasses");
        buttonPopulationBasicsCreateClasses.setText(_("isisfish.populationBasics.recreateClasses"));
        buttonPopulationBasicsCreateClasses.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__buttonPopulationBasicsCreateClasses"));
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
        create.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__create"));
    }

    protected void createFieldPopulationBasicsComment() {
        fieldPopulationBasicsComment = new javax.swing.JTextArea();
        $objectMap.put("fieldPopulationBasicsComment", fieldPopulationBasicsComment);
        fieldPopulationBasicsComment.setName("fieldPopulationBasicsComment");
        fieldPopulationBasicsComment.setColumns(15);
        fieldPopulationBasicsComment.setLineWrap(true);
        fieldPopulationBasicsComment.setWrapStyleWord(true);
        fieldPopulationBasicsComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationBasicsComment"));
    }

    protected void createFieldPopulationBasicsGeographicID() {
        fieldPopulationBasicsGeographicID = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationBasicsGeographicID", fieldPopulationBasicsGeographicID);
        fieldPopulationBasicsGeographicID.setName("fieldPopulationBasicsGeographicID");
        fieldPopulationBasicsGeographicID.setColumns(15);
        fieldPopulationBasicsGeographicID.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationBasicsGeographicID"));
    }

    protected void createFieldPopulationBasicsMatureClass() {
        fieldPopulationBasicsMatureClass = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationBasicsMatureClass", fieldPopulationBasicsMatureClass);
        fieldPopulationBasicsMatureClass.setName("fieldPopulationBasicsMatureClass");
        fieldPopulationBasicsMatureClass.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationBasicsMatureClass"));
    }

    protected void createFieldPopulationBasicsName() {
        fieldPopulationBasicsName = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationBasicsName", fieldPopulationBasicsName);
        fieldPopulationBasicsName.setName("fieldPopulationBasicsName");
        fieldPopulationBasicsName.setColumns(15);
        fieldPopulationBasicsName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationBasicsName"));
    }

    protected void createFieldPopulationBasicsNbClasses() {
        fieldPopulationBasicsNbClasses = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationBasicsNbClasses", fieldPopulationBasicsNbClasses);
        fieldPopulationBasicsNbClasses.setName("fieldPopulationBasicsNbClasses");
        fieldPopulationBasicsNbClasses.setColumns(15);
        fieldPopulationBasicsNbClasses.setEditable(false);
    }

    protected void createFieldPopulationBasicsPlusGroup() {
        fieldPopulationBasicsPlusGroup = new javax.swing.JCheckBox();
        $objectMap.put("fieldPopulationBasicsPlusGroup", fieldPopulationBasicsPlusGroup);
        fieldPopulationBasicsPlusGroup.setName("fieldPopulationBasicsPlusGroup");
        fieldPopulationBasicsPlusGroup.setText(_("isisfish.populationBasics.plusGroup"));
        fieldPopulationBasicsPlusGroup.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationBasicsPlusGroup"));
    }

    protected void createGrowthEquation() {
        growthEquation =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("growthEquation", growthEquation);
        growthEquation.removeDataBinding("$InputContentUI0.name");
        
        growthEquation.setName("growthEquation");
        growthEquation.removeDataBinding("$InputContentUI0.actif");
        
        growthEquation.removeDataBinding("$InputContentUI0.bean");
        
        growthEquation.removeDataBinding("$InputContentUI0.beanProperty");
        
        growthEquation.setBeanProperty("growth");
        growthEquation.removeDataBinding("$InputContentUI0.clazz");
        
        growthEquation.removeDataBinding("$InputContentUI0.formuleCategory");
        
        growthEquation.setFormuleCategory("Growth");
        growthEquation.removeDataBinding("$InputContentUI0.text");
        
        growthEquation.setText(_("isisfish.populationBasics.growth"));
    }

    protected void createGrowthReverseEquation() {
        growthReverseEquation =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("growthReverseEquation", growthReverseEquation);
        growthReverseEquation.removeDataBinding("$InputContentUI0.name");
        
        growthReverseEquation.setName("growthReverseEquation");
        growthReverseEquation.removeDataBinding("$InputContentUI0.actif");
        
        growthReverseEquation.removeDataBinding("$InputContentUI0.bean");
        
        growthReverseEquation.removeDataBinding("$InputContentUI0.beanProperty");
        
        growthReverseEquation.setBeanProperty("GrowthReverse");
        growthReverseEquation.removeDataBinding("$InputContentUI0.clazz");
        
        growthReverseEquation.removeDataBinding("$InputContentUI0.formuleCategory");
        
        growthReverseEquation.setFormuleCategory("GrowthReverse");
        growthReverseEquation.removeDataBinding("$InputContentUI0.text");
        
        growthReverseEquation.setText(_("isisfish.populationBasics.growthReverse"));
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

    protected void createTableAgeLength() {
        tableAgeLength = new javax.swing.JTable();
        $objectMap.put("tableAgeLength", tableAgeLength);
        tableAgeLength.setName("tableAgeLength");
        tableAgeLength.setEnabled(false);
        tableAgeLength.setRowHeight(24);
    }

}
