package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierImpl;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.MetierSeasonInfoImpl;
import fr.ifremer.isisfish.entities.Season;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.ui.input.metier.MetierSeasonInfoComboModel;
import fr.ifremer.isisfish.ui.widget.Interval;
import fr.ifremer.isisfish.ui.widget.IntervalPanel;

public class MetierSeasonInfoZoneUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVzW8bRRSfmHy1ITSUhqCSirS1ClJhnZCWUFI+mlQVGznph1sR1RfG3nEy1ezMMDPrbHsoSFwR6okDF+DOkTtCHDlx7f+Aqv4HvJm1vV53a69kH8b2m/d+7/fevPnN7/+hKa3Q2Qc4jj0VcUND4u1c29+/2XhAmuY60U1FpREKJZ+JEirV0VzQs2uDzterNrzSCa9si1AKTnhf9GYVHdfmISP6kBBj0GIS0dS6UuuZN2MZqS5aj0we2q/Pn5WeBN/9VkIolsBqCUpYGRWVVjBZRSUaGHQSMrVxhWF+ADQU5QfAc97athnWeg+H5Bv0GM1U0bTECsAMOle8VIfh4mNp0ELZ5zIy24IbcL/nrxq03lIebSkSEvjWVLeoPvQi6lHr6O0SQ4mqEawF93lL3Ic893wpHeS0QZMNgrlB7+aBQAYK0boD4oeSpYEL4QCyQWsFQFL/LNzSINyeMHsRYwa9bjvp2e56W0IwoJtGvVGuuX75HHJgRh8RtWbQO+4Mm9BUyoDKCy5D4z+0W0v9DRLBQ4PeysyFPoJT9u7iBiOp50zZGdbt32W7nO5tzZZ3qrhB2CWYFltO3EFIrNbpTM93cbATMB0N0a0qy8BeMbe9JeIsSjfjZfv/bHavBBWjiy8ZmyMaHBDj+TBgqo3ZLcwHCXahP8qBni/vQEcFc3EbcKyZatOtbNRcUrKdTRCCt19SaJVqYwPef4HJx6OYXLFGL+uw3KKEBf1TafNDN0N3RRczzO+S2FxTBNvYS3353YmvreYc+aTGbQITloHZiowR3Hpc6TlONzFvJj3+dHAHMhqStwPnJtqZHWVT2bHX2kvFMFWriTqaUhGzDV6op7p5B0yJYnasDsBZf/n+5/ZPf/z5SVceT0KO+YxLn5qDXEklJFH2rht0ItHEyFBW2cVys46OacLgKXBSf6qPQK1jBhKAn1x2G+Z9ifUhhE7NPP3r7ze//vcVVLqBjjOBgxvY+vvomDlUUKVgQSw//8IxefVoFtYFywnuI+H2dEChX7saYINXGpQHcAyfxVDtqb5qexT+efLD7vKPZza6FU8kjAbc0qqn7qNpyhnlxD0FHZXPlf45qUkUiFTN8/R9wn6vyI6k+G7dzStt0sA8gpZcTbKvYAPvTiMyBGqzQbcdefurVhDTmm/a5VY+wvkCrGbhcQuIImosnFFMLhRC+Mou++MgDOPw3tgIF8euYjSCFVbKaRiFNXjZhpD5oADUvFSkRZQiwdhgo3qzOjbC+tjdLYbwaAiHy4UQvh0bYVgfNor3YQjC/+r0q67eCwAA";
    protected fr.ifremer.isisfish.entities.MetierImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JTextArea fieldMetierSeasonZoneComment;
    protected fr.ifremer.isisfish.ui.widget.IntervalPanel ip;
    protected fr.ifremer.isisfish.entities.MetierSeasonInfoImpl metierSeasonInfo;
    protected jaxx.runtime.swing.JAXXComboBox metierSeasonInfoCombo;
    protected java.lang.Boolean metierSeasonInfoNotNull;
    protected jaxx.runtime.swing.JAXXList metierZones;
    protected javax.swing.JButton remove;
    protected javax.swing.JButton save;
    private fr.ifremer.isisfish.ui.input.MetierSeasonInfoZoneUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JScrollPane $JScrollPane7;
    private javax.swing.JScrollPane $JScrollPane9;
    private jaxx.runtime.swing.Table $Table10;
    private jaxx.runtime.swing.Table $Table3;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "metierSeasonInfoCombo.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "ip.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel6.enabled");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "metierZones.enabled");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel8.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldMetierSeasonZoneComment.enabled");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldMetierSeasonZoneComment.text");

    /* begin raw body code */
    protected Interval interval;
    protected boolean init;
    
    
        @Override
        public void refresh() {
            
            if (log.isDebugEnabled()) {
                log.debug("Refresh called in ui : " + this);
            }
    
            //if (!isActif()) {
            setMetierSeasonInfoNotNull(false);
            //}
    
            Metier metier = getVerifier().getEntity(Metier.class);
            // don't add setBean(null) here : useless
            setBean((MetierImpl) metier);
            
            if (getBean() != null) {
                // Model instanciation
                interval = new Interval();
                interval.setMin(0);
                interval.setMax(11);
                interval.setFirst(0);
                interval.setLast(2);
    
                setMetierSeasonInfoCombo();
                setSeason();
                setMetierZone();
                
                ip.setLabelRenderer(Month.MONTH);
                ip.setModel(interval);
            }
        }
        
        @Override
        public void setActionButtons() {
            getVerifier().setSaveButton(save, false);
            getVerifier().setCancelButton(cancel);
            getVerifier().setNewButton(create, "MetierSeasonInfo", false);
            getVerifier().setDeleteButton(remove, false);
        }
    
        protected void setSeason() {
            if (getMetierSeasonInfo() != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Refresh interval : ");
                    }
                    Month firstMonth = getMetierSeasonInfo().getFirstMonth();
                    if (firstMonth != null) {
                        interval.setFirst(firstMonth.getMonthNumber());
                        if (log.isDebugEnabled()) {
                            log.debug(" first : " + interval.getFirst());
                        }
                    } else {
                        interval.setFirst(0);
                    }
    
                    Month lastMonth = getMetierSeasonInfo().getLastMonth();
                    if (lastMonth != null) {
                        interval.setLast(lastMonth.getMonthNumber());
                        if (log.isDebugEnabled()) {
                            log.debug(" last : " + interval.getLast());
                        }
                    } else {
                        interval.setLast(3);
                    }
                } catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't display season", e);
                    }
                }
            }
        }
        protected void setMetierZone() {
            if (getMetierSeasonInfo() != null) {
                ListSelectionListener[] listeners = metierZones.getListSelectionListeners();
                for (ListSelectionListener listener : listeners) {
                    metierZones.removeListSelectionListener(listener);
                }
                metierZones.fillList(getRegion().getZone(), getMetierSeasonInfo().getZone());
                for (ListSelectionListener listener : listeners) {
                    metierZones.addListSelectionListener(listener);
                }
            }
        }
       
        protected void setMetierSeasonInfoCombo() {
            java.util.List<MetierSeasonInfo> metierSeasonInfoList = getBean().getMetierSeasonInfo();
            MetierSeasonInfoComboModel metierSeasonInfoModel = new MetierSeasonInfoComboModel(metierSeasonInfoList);
            metierSeasonInfoCombo.setModel(metierSeasonInfoModel);
        }
    
        protected void metierZonesChanged(){
            Object[] selected = metierZones.getSelectedValues();
            java.util.List<Zone> zones = new ArrayList<Zone>();
            for (Object o : selected){
                zones.add((Zone)o);
            }
            getMetierSeasonInfo().setZone(zones);
        }
        protected void seasonChanged() {
            jaxx.runtime.Util.assignment(init = true, "init", fr.ifremer.isisfish.ui.input.MetierSeasonInfoZoneUI.this);
            setMetierSeasonInfo((MetierSeasonInfoImpl)metierSeasonInfoCombo.getSelectedItem());
            getVerifier().addCurrentEntity(getMetierSeasonInfo());
            setMetierSeasonInfoNotNull(getMetierSeasonInfo() != null);
            setSeason();
            setMetierZone();
            jaxx.runtime.Util.assignment(init = false, "init", fr.ifremer.isisfish.ui.input.MetierSeasonInfoZoneUI.this);
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public MetierSeasonInfoZoneUI() {
        super();
        $initialize();
    }

    public MetierSeasonInfoZoneUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("metierSeasonInfoCombo.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonInfoNotNull", $DataSource14);
        
        } else if ("ip.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonInfoNotNull", $DataSource15);
        
        } else if ("$JLabel6.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonInfoNotNull", $DataSource16);
        
        } else if ("metierZones.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonInfoNotNull", $DataSource19);
        
        } else if ("$JLabel8.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonInfoNotNull", $DataSource20);
        
        } else if ("fieldMetierSeasonZoneComment.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonInfoNotNull", $DataSource23);
        
        } else if ("fieldMetierSeasonZoneComment.text".equals($binding)) {
                addPropertyChangeListener("metierSeasonInfo", $DataSource24);
        if (getMetierSeasonInfo() != null) {
                getMetierSeasonInfo().addPropertyChangeListener("seasonZoneComment", $DataSource24);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("metierSeasonInfoCombo.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                metierSeasonInfoCombo.setEnabled((isActif()));
            }
            } else if ("$JLabel5.enabled".equals($dest)) {
            $JLabel5.setEnabled((isMetierSeasonInfoNotNull()));
            } else if ("ip.enabled".equals($dest)) {
            ip.setEnabled((isMetierSeasonInfoNotNull()));
            } else if ("$JLabel6.enabled".equals($dest)) {
            $JLabel6.setEnabled((isMetierSeasonInfoNotNull()));
            } else if ("metierZones.enabled".equals($dest)) {
            metierZones.setEnabled((isMetierSeasonInfoNotNull()));
            } else if ("$JLabel8.enabled".equals($dest)) {
            $JLabel8.setEnabled((isMetierSeasonInfoNotNull()));
            } else if ("fieldMetierSeasonZoneComment.enabled".equals($dest)) {
            fieldMetierSeasonZoneComment.setEnabled((isMetierSeasonInfoNotNull()));
            } else if ("fieldMetierSeasonZoneComment.text".equals($dest)) {
            if (getMetierSeasonInfo() != null) {
                jaxx.runtime.SwingUtil.setText(fieldMetierSeasonZoneComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getMetierSeasonInfo().getSeasonZoneComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("metierSeasonInfoCombo.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonInfoNotNull", $DataSource14);
        
        } else if ("ip.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonInfoNotNull", $DataSource15);
        
        } else if ("$JLabel6.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonInfoNotNull", $DataSource16);
        
        } else if ("metierZones.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonInfoNotNull", $DataSource19);
        
        } else if ("$JLabel8.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonInfoNotNull", $DataSource20);
        
        } else if ("fieldMetierSeasonZoneComment.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonInfoNotNull", $DataSource23);
        
        } else if ("fieldMetierSeasonZoneComment.text".equals($binding)) {
                removePropertyChangeListener("metierSeasonInfo", $DataSource24);
        if (getMetierSeasonInfo() != null) {
                getMetierSeasonInfo().removePropertyChangeListener("seasonZoneComment", $DataSource24);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__metierSeasonInfoCombo(java.awt.event.ActionEvent event) {
        seasonChanged();
    }

    public void doKeyReleased__on__fieldMetierSeasonZoneComment(java.awt.event.KeyEvent event) {
        getMetierSeasonInfo().setSeasonZoneComment(fieldMetierSeasonZoneComment.getText());
    }

    public void doValueChanged__on__metierZones(javax.swing.event.ListSelectionEvent event) {
        metierZonesChanged();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.MetierImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JTextArea getFieldMetierSeasonZoneComment() {
        return fieldMetierSeasonZoneComment;
    }

    public fr.ifremer.isisfish.ui.widget.IntervalPanel getIp() {
        return ip;
    }

    public fr.ifremer.isisfish.entities.MetierSeasonInfoImpl getMetierSeasonInfo() {
        return metierSeasonInfo;
    }

    public jaxx.runtime.swing.JAXXComboBox getMetierSeasonInfoCombo() {
        return metierSeasonInfoCombo;
    }

    public java.lang.Boolean getMetierSeasonInfoNotNull() {
        return metierSeasonInfoNotNull;
    }

    public jaxx.runtime.swing.JAXXList getMetierZones() {
        return metierZones;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public java.lang.Boolean isMetierSeasonInfoNotNull() {
        return metierSeasonInfoNotNull !=null && metierSeasonInfoNotNull;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.MetierImpl newValue) {
        fr.ifremer.isisfish.entities.MetierImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setMetierSeasonInfo(fr.ifremer.isisfish.entities.MetierSeasonInfoImpl newValue) {
        fr.ifremer.isisfish.entities.MetierSeasonInfoImpl oldValue = this.metierSeasonInfo;
        this.metierSeasonInfo = newValue;
        firePropertyChange("metierSeasonInfo", oldValue, newValue);
    }

    public void setMetierSeasonInfoNotNull(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.metierSeasonInfoNotNull;
        this.metierSeasonInfoNotNull = newValue;
        firePropertyChange("metierSeasonInfoNotNull", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.MetierSeasonInfoZoneUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JScrollPane get$JScrollPane7() {
        return $JScrollPane7;
    }

    protected javax.swing.JScrollPane get$JScrollPane9() {
        return $JScrollPane9;
    }

    protected jaxx.runtime.swing.Table get$Table10() {
        return $Table10;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        
        
        addChildrenToBody();
        $Table3.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(metierSeasonInfoCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(ip), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel6, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JScrollPane7, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel8, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JScrollPane9, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        $JScrollPane7.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(metierZones));
        
        
        $JScrollPane9.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldMetierSeasonZoneComment));
        
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("metierSeasonInfoCombo.enabled");
        metierSeasonInfoCombo.setRenderer((new fr.ifremer.isisfish.ui.input.metier.MetierSeasonInfoComboRenderer()));
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("ip.enabled");
        applyDataBinding("$JLabel6.enabled");
        $JScrollPane7.setMinimumSize((new Dimension(0,0)));
        $JScrollPane7.setPreferredSize((new Dimension(0,0)));
        applyDataBinding("metierZones.enabled");
        applyDataBinding("$JLabel8.enabled");
        $JScrollPane9.setMinimumSize((new Dimension(0,0)));
        $JScrollPane9.setPreferredSize((new Dimension(0,0)));
        applyDataBinding("fieldMetierSeasonZoneComment.enabled");
        applyDataBinding("fieldMetierSeasonZoneComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createMetierSeasonInfo();
        createMetierSeasonInfoNotNull();
        
        interval = null;
        
        init = false;
        
        $Table3 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table3", $Table3);
        $Table3.setName("$Table3");
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.metierSeasonInfoZone.selectSeason"));
        
        createMetierSeasonInfoCombo();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.metierSeasonInfoZone.season"));
        
        createIp();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.common.zone"));
        
        $JScrollPane7 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane7", $JScrollPane7);
        $JScrollPane7.setName("$JScrollPane7");
        
        createMetierZones();
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.metierSeasonInfoZone.comments"));
        
        $JScrollPane9 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane9", $JScrollPane9);
        $JScrollPane9.setName("$JScrollPane9");
        
        createFieldMetierSeasonZoneComment();
        
        $Table10 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table10", $Table10);
        $Table10.setName("$Table10");
        
        createSave();
        createCancel();
        createCreate();
        createRemove();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        /*
             * Don't add both in same listener.
             * When first is set, last value from getPopulationSeasonInfo()
             * is erased by interval.getLast() default value.
             */
            ip.addPropertyChangeListener("first", new PropertyChangeListener() {
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (getMetierSeasonInfo() != null) {
                        getMetierSeasonInfo().setFirstMonth(new Month(interval.getFirst()));
                    }
                }
            });ip.addPropertyChangeListener("last", new PropertyChangeListener() {
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (getMetierSeasonInfo() != null) {
                        getMetierSeasonInfo().setLastMonth(new Month(interval.getLast()));
                    }
                }
            });save.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    getVerifier().topiaSave();
                    setMetierSeasonInfoCombo();
                }
            });create.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    getContextValue(InputAction.class).createMetierSeasonInfo(getBean());
                    setMetierSeasonInfoCombo();
                }
                
            });remove.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    getContextValue(InputAction.class).removeMetierSeasonInfo(getBean(), getMetierSeasonInfo());
                    setMetierSeasonInfoCombo();
                }
            });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table10, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
    }

    protected void createFieldMetierSeasonZoneComment() {
        fieldMetierSeasonZoneComment = new javax.swing.JTextArea();
        $objectMap.put("fieldMetierSeasonZoneComment", fieldMetierSeasonZoneComment);
        fieldMetierSeasonZoneComment.setName("fieldMetierSeasonZoneComment");
        fieldMetierSeasonZoneComment.setColumns(15);
        fieldMetierSeasonZoneComment.setLineWrap(true);
        fieldMetierSeasonZoneComment.setWrapStyleWord(true);
        fieldMetierSeasonZoneComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldMetierSeasonZoneComment"));
    }

    protected void createIp() {
        ip = new fr.ifremer.isisfish.ui.widget.IntervalPanel();
        $objectMap.put("ip", ip);
        ip.setName("ip");
    }

    protected void createMetierSeasonInfo() {
        metierSeasonInfo = null;
        $objectMap.put("metierSeasonInfo", metierSeasonInfo);
    }

    protected void createMetierSeasonInfoCombo() {
        metierSeasonInfoCombo = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("metierSeasonInfoCombo", metierSeasonInfoCombo);
        metierSeasonInfoCombo.setName("metierSeasonInfoCombo");
        metierSeasonInfoCombo.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__metierSeasonInfoCombo"));
    }

    protected void createMetierSeasonInfoNotNull() {
        metierSeasonInfoNotNull = false;
        $objectMap.put("metierSeasonInfoNotNull", metierSeasonInfoNotNull);
    }

    protected void createMetierZones() {
        metierZones = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("metierZones", metierZones);
        metierZones.setName("metierZones");
        metierZones.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $InputContentUI0, "doValueChanged__on__metierZones"));
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

}
