package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.entities.FisheryRegionImpl;
import fr.ifremer.isisfish.ui.Common;
import fr.ifremer.isisfish.ui.WelcomeSaveVerifier;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.swing.navigation.NavigationTreeModel.NavigationTreeNode;
import jaxx.runtime.swing.navigation.NavigationUtil;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import org.nuiton.topia.TopiaContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputUI extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.input.InputUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVYzVMcRRRvVpZvMAJGy2hCApbl18ASEhJBTIBgllowsmBF14PNTrPbcWZ60tPDDrHKssqrZXHy4EU95ObRu2V59JSr/0PK8urJ17278xFmZ6ZqOMzOvo9f/9573e/18utTVHQ4uvwAe57GXUtQk2jbt+/f/+jwAamLTeLUObUF46j911dAhRoa1X25I9BsrSLd5zvu8xvMtJlFrJD3SgWNOOLEIE6TECHQi22PuuPMV33xime7vIvmk4lD+/nffwqn+je/FBDybGA1CyHMpHkFEfRXUIHqAk3CSsd43sBWA2hwajWA57iUbRjYcXaxSR6ir9FgBQ3YmAOYQFeyh6owlL9nCzQ0t30PW8RYEGjuiGv0iBOTwKdDnSPqNDWXatSyXaGV5fOgbNvKd0Cgly18TBtYUGZViQFFgZcdphNDoLckV09zWkBdE5wQbZMcYdcQ+/AeNQ7wXgnwpNkGMYw9YumEEy7Qajq33Z7uwRojdcx1A58wF3J2MVKZNtkN0FeUfjHwmgq87kE16tTGEOSUDFLDLRFyCnwGOGkAFYG0OOZQGSoocbQt+Eb4yZ4yLpt2KB/9JrFcgabDudzeAdk65tJk2LccnFPykkAvnDGWJhd8y9G2ZVkQcxF2+xlrqZCmF+M8rkrRbE/1UrL6WrL6erJ6OUY9NrddJXAAMOzuGwKdj0Tja3pC3oyBHOpkckF+n4nmbixwLZV836ux+sUY/XiIbknlcqE3wFIMQJfctRRyQSrfjyxuG1TIs15aPpOsriq6r4Y7vaEE2Z2MOCixtLodYrePDw1SugmdIeZgKaU03fQ9Jo4oMfRd0trrHJUoqX3iiS1pIc0/9L3Oba/D4WVWyG8q4tdWR50m1VIbLpfdsut2KYamHDHQPA/ZOvOiEMOyj/lxbz0TCqS3zplhSINF6KUvRfPr66R9NWhHQcsT6EIPOrKbSfuDIBrV9SSc3458TkFBBiyYAAdlmIOJvXNXWUmfWhCrv4CPC0ouEw0UYTpqwXQMxldfDRW5C2IoUi0YpHsgao/QjlQBKOlP3/54/MNvv7/XnZfvwBrjEZPQeIf5ZXNmwzSgconn20PSFdSY38H2Sg0NO2qyqNk/HSJQ7YiBBOCrFqlJN+0udprgWhz8+48/z3/x5DlU2EIjBsP6Fpb2Zah5k0OUzNA9+4NbislYawie5yQnSHF3lEys6ljgmUNq6VC2NQ+CnQ4F6zP46/S7nVe/f225G3Bfm9AzZkHQxc/QALUMahF1NehM/dirwKjtEFdnwXSPm/d98nPE7gyZhnp+GRfZuBOe0tLM8tQsYYq1fHuowMYzgPULOMqwbVfbocxgAZeaQ1eQtXjMS6mYUvxIPr6KR7iSG+H13Ahv5EZ4M0NuB4klO6ueUKK3cxPJhnCawOHd3ByyISRxWMyyVa3OierBIh0jLY78CEu5M3E9N4dsCEkcbuTmkA0hicNqJoTHCRyyISRFkR9hLXcebuXmkI4AE1unxxR+kFVYXV15EuDWM8BNwsVln7n15h3PxpbevV/mQBxlnML9MD85KTYT8n0nCxmTWtR0zSp9lDR/06H84vcIZzd38dMRBCqa8td+QiAf587qfu7TnI4Av7Tqof8sJLD5NBOb/3IhwC7hjIlP4FafvPuzQA1z1rpLaKMpcgJNRO6OSTXPgjbmo+2xVi5mafvn80wIT3MjJHHAgPA/Eh9k5fwUAAA=";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JButton JButtonNewRegion;
    protected jaxx.runtime.swing.CardLayout2 cardlayout;
    protected java.awt.CardLayout cardlayoutPrincipal;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected jaxx.runtime.swing.JAXXComboBox fieldCurrentRegion;
    protected javax.swing.JTextField fieldNewRegion;
    protected javax.swing.JPanel inputPane;
    protected javax.swing.JPanel inputPanePrincipal;
    protected javax.swing.JMenuBar menu;
    protected jaxx.runtime.swing.JAXXTree navigation;
    protected javax.swing.tree.DefaultTreeSelectionModel navigationSelectionModel;
    protected fr.ifremer.isisfish.ui.input.InputNavigationTreeCellRenderer navigationTreeCellRenderer;
    protected fr.ifremer.isisfish.ui.input.NoneUI noneUI;
    protected fr.ifremer.isisfish.entities.FisheryRegionImpl region;
    protected javax.swing.JPanel treePanel;
    private javax.swing.JMenu $JMenu1;
    private javax.swing.JMenu $JMenu10;
    private javax.swing.JMenu $JMenu15;
    private javax.swing.JMenuItem $JMenuItem11;
    private javax.swing.JMenuItem $JMenuItem12;
    private javax.swing.JMenuItem $JMenuItem14;
    private javax.swing.JMenuItem $JMenuItem16;
    private javax.swing.JMenuItem $JMenuItem2;
    private javax.swing.JMenuItem $JMenuItem3;
    private javax.swing.JMenuItem $JMenuItem4;
    private javax.swing.JMenuItem $JMenuItem5;
    private javax.swing.JMenuItem $JMenuItem6;
    private javax.swing.JMenuItem $JMenuItem7;
    private javax.swing.JMenuItem $JMenuItem9;
    private fr.ifremer.isisfish.ui.input.InputUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel18;
    private javax.swing.JScrollPane $JScrollPane20;
    private javax.swing.JSeparator $JSeparator13;
    private javax.swing.JSeparator $JSeparator8;
    private javax.swing.JSplitPane $JSplitPane17;
    private jaxx.runtime.swing.Table $Table19;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($JPanel0, "$JMenuItem6.enabled");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($JPanel0, "$JMenuItem7.enabled");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($JPanel0, "$JMenuItem9.enabled");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($JPanel0, "$JMenuItem11.enabled");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($JPanel0, "$JMenuItem12.enabled");
    private java.beans.PropertyChangeListener $DataSource28 = new jaxx.runtime.DataBindingListener($JPanel0, "$JMenuItem14.enabled");
    private java.beans.PropertyChangeListener $DataSource29 = new jaxx.runtime.DataBindingListener($JPanel0, "$JMenuItem16.enabled");
    private java.beans.PropertyChangeListener $DataSource32 = new jaxx.runtime.DataBindingListener($JPanel0, "fieldCurrentRegion.model");

    /* begin raw body code */
    StorageChangeListener regionStorageListener;
    
    
    protected InputAction getAction() {
        return getContextValue(InputAction.class);
    }
    protected InputSaveVerifier getVerifier() {
        return getContextValue(InputSaveVerifier.class);
    }
    protected RegionStorage getRegionStorage() {
        return getContextValue(RegionStorage.class);
    }
    protected void setFieldCurrentRegionModel() {
        fieldCurrentRegion.setModel(getFieldCurrentRegionModel());
    }
    protected DefaultComboBoxModel getFieldCurrentRegionModel() {
        return new DefaultComboBoxModel(Common.getRegionItem());
    }
    protected void regionChange(ItemEvent e) {
        // event launched twice with itemchange listener
        if (e.getStateChange() == ItemEvent.SELECTED) {
            final String name = fieldCurrentRegion.getSelectedItem().toString();
            if (log.isDebugEnabled()) {
                log.debug("Region change, selected : " + name);
            }
    
            // long operation, run status bar
            setStatusMessage(_("isisfish.message.loading.region", name), true);
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    loadRegion(name);
                    getVerifier().setIsisContext(getContextValue(TopiaContext.class));
                    setStatusMessage(_("isisfish.message.load.finished"));
                    setTreeModel();
                }
            });
        }
    }
    protected void loadRegion(String name) {
        if (log.isDebugEnabled()) {
            log.debug("Loadregion : " + name);
        }
        setRegion((FisheryRegionImpl)getAction().loadRegion(this, name));
        if (getRegion() == null) {
            regionNull();
        }
        else {
            setTreeModel();
            getCardlayoutPrincipal().show(inputPanePrincipal,"normale");
        }
    }
    protected void setTreeModel() {
        if (getRegion() != null) {
            String regionName = getRegion().getName();
            setContextValue(getRegion());
            NavigationTreeModel model = InputNavigationTreeSelectionAdapter.getTreeModel(regionName, getRegion());
    
            setContextValue(model);
            navigation.setModel(model);
            setTreeSelection("$root");
            
            /*TC-20090702 Fix bug #1772
            EC-20090706 no working solution found
            model.nodeChanged(model.getRoot());
            java.util.Enumeration<?> e = model.getRoot().children();
            while (e.hasMoreElements()) {
                NavigationTreeNode n = (NavigationTreeNode) e.nextElement();
                String contextPath = n.getContextPath();
                if (contextPath.equals("$root/$cells")) {
                    //TC-20090702 : ce noeud est trop long a recharger
                    continue;
                }
                log.debug("reload node " + contextPath);
                model.nodeChanged(n);
                java.util.Enumeration<?> e2 = n.children();
                while (e2.hasMoreElements()) {
                    NavigationTreeNode n2 = (NavigationTreeNode) e2.nextElement();
                    n2.getJAXXContextValue(InputUI.this);
                }
            }*/
        }
    }
    
    public void repaintNode(String path) {
        NavigationTreeModel model = getContextValue(NavigationTreeModel.class);
        NavigationTreeNode currentNode = model.findNode(path);
        model.nodeChanged(currentNode);
    }
    public void setTreeSelection(String path) {
        NavigationTreeNode node = NavigationUtil.findNode(this, null, path);
        TreePath pathToRoot = new TreePath(getContextValue(NavigationTreeModel.class).getPathToRoot(node));
        navigation.setSelectionPath(pathToRoot);
        navigation.scrollPathToVisible(pathToRoot);
    }
    protected void setStatusMessage(String s) {
        WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
        root.setStatusMessage(s);
    }
    protected void setStatusMessage(String s, boolean running) {
        WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
        root.setStatusMessage(s, running);
    }
    protected void newRegion() {
        String name = fieldNewRegion.getText();
        setStatusMessage(_("isisfish.message.creating.region", name), true);
        getContextValue(InputAction.class).newRegion(name);
        fieldCurrentRegion.setSelectedItem(name);
        JButtonNewRegion.setEnabled(false);
        fieldNewRegion.setText("");
        setStatusMessage(_("isisfish.message.creation.finished"));
    }
    protected void regionNull() {
        getCardlayoutPrincipal().show(inputPanePrincipal,"none");
        DefaultTreeModel model = new DefaultTreeModel(null);
        navigation.setModel(model);
    }
    protected void newChanged() {
        JButtonNewRegion.setEnabled(true);
    }
    protected void importRegion() {
        setStatusMessage(_("isisfish.message.import.zip"), true);
        getContextValue(InputAction.class).importRegion();
        setStatusMessage(_("isisfish.message.import.finished"));
    }
    protected void importRegionAndRename() {
        setStatusMessage(_("isisfish.message.import.zip"), true);
        getContextValue(InputAction.class).importRegionAndRename();
        setStatusMessage(_("isisfish.message.import.finished"));
    }
    protected void importV2Region() {
        setStatusMessage(_("isisfish.message.import.xml.v2.file") + getContextValue(InputAction.class).importV2Region(), true);
        setStatusMessage(_("isisfish.message.import.finished"));
    }
    protected void importRegionFromSimulation() {
        setStatusMessage(_("isisfish.message.import", getContextValue(InputAction.class).importRegionFromSimulation()), true);
        setStatusMessage(_("isisfish.message.export.done"));
    }
    protected void exportRegion() {
        setStatusMessage(_("isisfish.message.export.zip", getContextValue(InputAction.class).exportRegion(getRegionStorage())), true);
        setStatusMessage(_("isisfish.message.export.done"));
    }
    protected void copyRegion() {
        // TODO region name in not knwon before copy
        setStatusMessage(_("isisfish.message.copy.region"), true);
        getContextValue(InputAction.class).copyRegion(getRegionStorage());
        setStatusMessage(_("isisfish.message.copy.finished"));
    }
    protected void removeRegion(boolean deletecvs) {
        setStatusMessage(_("isisfish.message.removing.region", getRegionStorage().getName()), true);
        boolean deleted = getContextValue(InputAction.class).removeRegion(getRegionStorage(), deletecvs);
        if (deleted) {
            setStatusMessage(_("isisfish.message.region.removed"));
            regionNull();
        }
        else {
            setStatusMessage(_("isisfish.message.region.remove.canceled"));
        }
    }
    protected void commitRegionInCVS() {
        setStatusMessage(_("isisfish.message.commiting.region", getRegionStorage().getName()), true);
        setStatusMessage(getContextValue(InputAction.class).commitRegionInCVS(getRegionStorage()));
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public InputUI() {
        $initialize();
    }

    public InputUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JMenuItem6.enabled".equals($binding)) {
                addPropertyChangeListener("region", $DataSource23);
        
        } else if ("$JMenuItem7.enabled".equals($binding)) {
                addPropertyChangeListener("region", $DataSource24);
        
        } else if ("$JMenuItem9.enabled".equals($binding)) {
                addPropertyChangeListener("region", $DataSource25);
        
        } else if ("$JMenuItem11.enabled".equals($binding)) {
                addPropertyChangeListener("region", $DataSource26);
        
        } else if ("$JMenuItem12.enabled".equals($binding)) {
                addPropertyChangeListener("region", $DataSource27);
        
        } else if ("$JMenuItem14.enabled".equals($binding)) {
                addPropertyChangeListener("region", $DataSource28);
        
        } else if ("$JMenuItem16.enabled".equals($binding)) {
                addPropertyChangeListener("region", $DataSource29);
        
        } else if ("fieldCurrentRegion.model".equals($binding)) {
                addPropertyChangeListener("fieldCurrentRegionModel", $DataSource32);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JMenuItem6.enabled".equals($dest)) {
            $JMenuItem6.setEnabled((getRegion() != null));
            } else if ("$JMenuItem7.enabled".equals($dest)) {
            $JMenuItem7.setEnabled((getRegion() != null));
            } else if ("$JMenuItem9.enabled".equals($dest)) {
            $JMenuItem9.setEnabled((getRegion() != null));
            } else if ("$JMenuItem11.enabled".equals($dest)) {
            $JMenuItem11.setEnabled((getRegion() != null));
            } else if ("$JMenuItem12.enabled".equals($dest)) {
            $JMenuItem12.setEnabled((getRegion() != null));
            } else if ("$JMenuItem14.enabled".equals($dest)) {
            $JMenuItem14.setEnabled((getRegion() != null));
            } else if ("$JMenuItem16.enabled".equals($dest)) {
            $JMenuItem16.setEnabled((getRegion() != null));
            } else if ("fieldCurrentRegion.model".equals($dest)) {
            fieldCurrentRegion.setModel((getFieldCurrentRegionModel()));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JMenuItem6.enabled".equals($binding)) {
                removePropertyChangeListener("region", $DataSource23);
        
        } else if ("$JMenuItem7.enabled".equals($binding)) {
                removePropertyChangeListener("region", $DataSource24);
        
        } else if ("$JMenuItem9.enabled".equals($binding)) {
                removePropertyChangeListener("region", $DataSource25);
        
        } else if ("$JMenuItem11.enabled".equals($binding)) {
                removePropertyChangeListener("region", $DataSource26);
        
        } else if ("$JMenuItem12.enabled".equals($binding)) {
                removePropertyChangeListener("region", $DataSource27);
        
        } else if ("$JMenuItem14.enabled".equals($binding)) {
                removePropertyChangeListener("region", $DataSource28);
        
        } else if ("$JMenuItem16.enabled".equals($binding)) {
                removePropertyChangeListener("region", $DataSource29);
        
        } else if ("fieldCurrentRegion.model".equals($binding)) {
                removePropertyChangeListener("fieldCurrentRegionModel", $DataSource32);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem11(java.awt.event.ActionEvent event) {
        commitRegionInCVS();
    }

    public void doActionPerformed__on__$JMenuItem12(java.awt.event.ActionEvent event) {
        commitRegionInCVS();
    }

    public void doActionPerformed__on__$JMenuItem14(java.awt.event.ActionEvent event) {
        removeRegion(true);
    }

    public void doActionPerformed__on__$JMenuItem16(java.awt.event.ActionEvent event) {
        getAction().exportRegionSensitivityFactors(this, getRegion());
    }

    public void doActionPerformed__on__$JMenuItem2(java.awt.event.ActionEvent event) {
        importRegion();
    }

    public void doActionPerformed__on__$JMenuItem3(java.awt.event.ActionEvent event) {
        importRegionAndRename();
    }

    public void doActionPerformed__on__$JMenuItem4(java.awt.event.ActionEvent event) {
        importV2Region();
    }

    public void doActionPerformed__on__$JMenuItem5(java.awt.event.ActionEvent event) {
        importRegionFromSimulation();
    }

    public void doActionPerformed__on__$JMenuItem6(java.awt.event.ActionEvent event) {
        exportRegion();
    }

    public void doActionPerformed__on__$JMenuItem7(java.awt.event.ActionEvent event) {
        copyRegion();
    }

    public void doActionPerformed__on__$JMenuItem9(java.awt.event.ActionEvent event) {
        removeRegion(false);
    }

    public void doActionPerformed__on__JButtonNewRegion(java.awt.event.ActionEvent event) {
        newRegion();
    }

    public void doItemStateChanged__on__fieldCurrentRegion(java.awt.event.ItemEvent event) {
        regionChange(event);
    }

    public void doKeyReleased__on__fieldNewRegion(java.awt.event.KeyEvent event) {
        newChanged();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public jaxx.runtime.swing.CardLayout2 getCardlayout() {
        return cardlayout;
    }

    public java.awt.CardLayout getCardlayoutPrincipal() {
        return cardlayoutPrincipal;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldCurrentRegion() {
        return fieldCurrentRegion;
    }

    public javax.swing.JTextField getFieldNewRegion() {
        return fieldNewRegion;
    }

    public javax.swing.JPanel getInputPane() {
        return inputPane;
    }

    public javax.swing.JPanel getInputPanePrincipal() {
        return inputPanePrincipal;
    }

    public javax.swing.JButton getJButtonNewRegion() {
        return JButtonNewRegion;
    }

    public javax.swing.JMenuBar getMenu() {
        return menu;
    }

    public jaxx.runtime.swing.JAXXTree getNavigation() {
        return navigation;
    }

    public javax.swing.tree.DefaultTreeSelectionModel getNavigationSelectionModel() {
        return navigationSelectionModel;
    }

    public fr.ifremer.isisfish.ui.input.InputNavigationTreeCellRenderer getNavigationTreeCellRenderer() {
        return navigationTreeCellRenderer;
    }

    public fr.ifremer.isisfish.ui.input.NoneUI getNoneUI() {
        return noneUI;
    }

    public fr.ifremer.isisfish.entities.FisheryRegionImpl getRegion() {
        return region;
    }

    public javax.swing.JPanel getTreePanel() {
        return treePanel;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setRegion(fr.ifremer.isisfish.entities.FisheryRegionImpl newValue) {
        fr.ifremer.isisfish.entities.FisheryRegionImpl oldValue = this.region;
        this.region = newValue;
        firePropertyChange("region", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JMenu get$JMenu1() {
        return $JMenu1;
    }

    protected javax.swing.JMenu get$JMenu10() {
        return $JMenu10;
    }

    protected javax.swing.JMenu get$JMenu15() {
        return $JMenu15;
    }

    protected javax.swing.JMenuItem get$JMenuItem11() {
        return $JMenuItem11;
    }

    protected javax.swing.JMenuItem get$JMenuItem12() {
        return $JMenuItem12;
    }

    protected javax.swing.JMenuItem get$JMenuItem14() {
        return $JMenuItem14;
    }

    protected javax.swing.JMenuItem get$JMenuItem16() {
        return $JMenuItem16;
    }

    protected javax.swing.JMenuItem get$JMenuItem2() {
        return $JMenuItem2;
    }

    protected javax.swing.JMenuItem get$JMenuItem3() {
        return $JMenuItem3;
    }

    protected javax.swing.JMenuItem get$JMenuItem4() {
        return $JMenuItem4;
    }

    protected javax.swing.JMenuItem get$JMenuItem5() {
        return $JMenuItem5;
    }

    protected javax.swing.JMenuItem get$JMenuItem6() {
        return $JMenuItem6;
    }

    protected javax.swing.JMenuItem get$JMenuItem7() {
        return $JMenuItem7;
    }

    protected javax.swing.JMenuItem get$JMenuItem9() {
        return $JMenuItem9;
    }

    protected fr.ifremer.isisfish.ui.input.InputUI get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel18() {
        return $JPanel18;
    }

    protected javax.swing.JScrollPane get$JScrollPane20() {
        return $JScrollPane20;
    }

    protected javax.swing.JSeparator get$JSeparator13() {
        return $JSeparator13;
    }

    protected javax.swing.JSeparator get$JSeparator8() {
        return $JSeparator8;
    }

    protected javax.swing.JSplitPane get$JSplitPane17() {
        return $JSplitPane17;
    }

    protected jaxx.runtime.swing.Table get$Table19() {
        return $Table19;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JPanel0.add(menu, BorderLayout.NORTH);
        $JPanel0.add($JSplitPane17, BorderLayout.CENTER);
        
        addChildrenToMenu();
        $JMenu1.add($JMenuItem2);
        $JMenu1.add($JMenuItem3);
        $JMenu1.add($JMenuItem4);
        $JMenu1.add($JMenuItem5);
        $JMenu1.add($JMenuItem6);
        $JMenu1.add($JMenuItem7);
        $JMenu1.add($JSeparator8);
        $JMenu1.add($JMenuItem9);
        
        
        
        
        
        
        
        
        
        $JMenu10.add($JMenuItem11);
        $JMenu10.add($JMenuItem12);
        $JMenu10.add($JSeparator13);
        $JMenu10.add($JMenuItem14);
        
        
        
        
        
        $JMenu15.add($JMenuItem16);
        
        
        $JSplitPane17.add($JPanel18, JSplitPane.LEFT);
        $JSplitPane17.add(inputPanePrincipal, JSplitPane.RIGHT);
        
        $JPanel18.add($Table19, BorderLayout.NORTH);
        $JPanel18.add(treePanel);
        
        $Table19.add(fieldNewRegion, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table19.add(JButtonNewRegion, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table19.add(fieldCurrentRegion, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        addChildrenToTreePanel();
        $JScrollPane20.getViewport().add(navigation);
        
        addChildrenToInputPanePrincipal();
        navigationSelectionModel.setSelectionMode((javax.swing.tree.TreeSelectionModel.SINGLE_TREE_SELECTION));
        applyDataBinding("$JMenuItem6.enabled");
        applyDataBinding("$JMenuItem7.enabled");
        applyDataBinding("$JMenuItem9.enabled");
        applyDataBinding("$JMenuItem11.enabled");
        applyDataBinding("$JMenuItem12.enabled");
        applyDataBinding("$JMenuItem14.enabled");
        applyDataBinding("$JMenuItem16.enabled");
        $JPanel18.setMinimumSize((new java.awt.Dimension(0,0)));
        applyDataBinding("fieldCurrentRegion.model");
        navigation.setCellRenderer((getNavigationTreeCellRenderer()));
        navigation.setModel((new DefaultTreeModel(null)));
        navigation.setSelectionModel((getNavigationSelectionModel()));
        inputPanePrincipal.setMinimumSize((new java.awt.Dimension(0,0)));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createNavigationSelectionModel();
        createNavigationTreeCellRenderer();
        createCardlayout();
        createCardlayoutPrincipal();
        createRegion();
        createMenu();
        
        $JMenu1 = new javax.swing.JMenu();
        $objectMap.put("$JMenu1", $JMenu1);
        $JMenu1.setName("$JMenu1");
        $JMenu1.setText(_("isisfish.common.region"));
        
        $JMenuItem2 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem2", $JMenuItem2);
        $JMenuItem2.setName("$JMenuItem2");
        $JMenuItem2.setText(_("isisfish.input.menu.importRegion"));
        $JMenuItem2.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem2"));
        
        create$JMenuItem3();
        create$JMenuItem4();
        create$JMenuItem5();
        
        $JMenuItem6 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem6", $JMenuItem6);
        $JMenuItem6.setName("$JMenuItem6");
        $JMenuItem6.setText(_("isisfish.input.menu.exportRegion"));
        $JMenuItem6.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem6"));
        
        $JMenuItem7 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem7", $JMenuItem7);
        $JMenuItem7.setName("$JMenuItem7");
        $JMenuItem7.setText(_("isisfish.input.menu.copyRegion"));
        $JMenuItem7.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem7"));
        
        $JSeparator8 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator8", $JSeparator8);
        $JSeparator8.setName("$JSeparator8");
        
        create$JMenuItem9();
        
        $JMenu10 = new javax.swing.JMenu();
        $objectMap.put("$JMenu10", $JMenu10);
        $JMenu10.setName("$JMenu10");
        $JMenu10.setText(_("isisfish.input.menu.server"));
        
        create$JMenuItem11();
        
        $JMenuItem12 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem12", $JMenuItem12);
        $JMenuItem12.setName("$JMenuItem12");
        $JMenuItem12.setText(_("isisfish.input.menu.commit"));
        $JMenuItem12.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem12"));
        
        $JSeparator13 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator13", $JSeparator13);
        $JSeparator13.setName("$JSeparator13");
        
        create$JMenuItem14();
        
        $JMenu15 = new javax.swing.JMenu();
        $objectMap.put("$JMenu15", $JMenu15);
        $JMenu15.setName("$JMenu15");
        $JMenu15.setText(_("isisfish.input.menu.sensitivity"));
        
        create$JMenuItem16();
        
        $JSplitPane17 = new javax.swing.JSplitPane();
        $objectMap.put("$JSplitPane17", $JSplitPane17);
        $JSplitPane17.setName("$JSplitPane17");
        $JSplitPane17.setDividerLocation(200);
        $JSplitPane17.setOneTouchExpandable(true);
        $JSplitPane17.setOrientation(1);
        
        $JPanel18 = new javax.swing.JPanel();
        $objectMap.put("$JPanel18", $JPanel18);
        $JPanel18.setName("$JPanel18");
        $JPanel18.setLayout((new BorderLayout()));
        
        $Table19 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table19", $Table19);
        $Table19.setName("$Table19");
        
        createFieldNewRegion();
        createJButtonNewRegion();
        createFieldCurrentRegion();
        createTreePanel();
        
        $JScrollPane20 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane20", $JScrollPane20);
        $JScrollPane20.setName("$JScrollPane20");
        
        createNavigation();
        createInputPanePrincipal();
        createNoneUI();
        createInputPane();
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout((new BorderLayout()));
        
        
        getContextValue(WelcomeSaveVerifier.class).addSaveVerifier(getVerifier());new fr.ifremer.isisfish.ui.input.InputNavigationTreeSelectionAdapter(this);jaxx.runtime.Util.assignment(regionStorageListener = new StorageChangeListener() {
            @Override
            public void versionDataChanged(StorageChangeEvent e) {
                setFieldCurrentRegionModel();
            }
        }, "regionStorageListener", fr.ifremer.isisfish.ui.input.InputUI.this);RegionStorage.addStorageChangeListener(regionStorageListener);
        $completeSetup();
    }

    protected void addChildrenToInputPanePrincipal() {
        if (!allComponentsCreated) {
            return;
        }
        inputPanePrincipal.add(noneUI, "none");
        inputPanePrincipal.add(inputPane, "normale");
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add($JMenu1);
        menu.add($JMenu10);
        menu.add($JMenu15);
    }

    protected void addChildrenToTreePanel() {
        if (!allComponentsCreated) {
            return;
        }
        treePanel.add($JScrollPane20, BorderLayout.CENTER);
    }

    protected void create$JMenuItem11() {
        $JMenuItem11 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem11", $JMenuItem11);
        $JMenuItem11.setName("$JMenuItem11");
        $JMenuItem11.setText(_("isisfish.input.menu.addRegion"));
        $JMenuItem11.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem11"));
    }

    protected void create$JMenuItem14() {
        $JMenuItem14 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem14", $JMenuItem14);
        $JMenuItem14.setName("$JMenuItem14");
        $JMenuItem14.setName("miRemove");
        $JMenuItem14.setText(_("isisfish.input.menu.removeLocalyRemotely"));
        $JMenuItem14.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem14"));
    }

    protected void create$JMenuItem16() {
        $JMenuItem16 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem16", $JMenuItem16);
        $JMenuItem16.setName("$JMenuItem16");
        $JMenuItem16.setText(_("isisfish.input.menu.sensitivity.export"));
        $JMenuItem16.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem16"));
    }

    protected void create$JMenuItem3() {
        $JMenuItem3 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem3", $JMenuItem3);
        $JMenuItem3.setName("$JMenuItem3");
        $JMenuItem3.setText(_("isisfish.input.menu.importRenameRegion"));
        $JMenuItem3.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem3"));
    }

    protected void create$JMenuItem4() {
        $JMenuItem4 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem4", $JMenuItem4);
        $JMenuItem4.setName("$JMenuItem4");
        $JMenuItem4.setText(_("isisfish.input.menu.importRegionV2"));
        $JMenuItem4.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem4"));
    }

    protected void create$JMenuItem5() {
        $JMenuItem5 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem5", $JMenuItem5);
        $JMenuItem5.setName("$JMenuItem5");
        $JMenuItem5.setText(_("isisfish.input.menu.importRegionSimulation"));
        $JMenuItem5.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem5"));
    }

    protected void create$JMenuItem9() {
        $JMenuItem9 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem9", $JMenuItem9);
        $JMenuItem9.setName("$JMenuItem9");
        $JMenuItem9.setName("miRemove");
        $JMenuItem9.setText(_("isisfish.input.menu.removeLocaly"));
        $JMenuItem9.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__$JMenuItem9"));
    }

    protected void createCardlayout() {
        cardlayout = new jaxx.runtime.swing.CardLayout2();
        $objectMap.put("cardlayout", cardlayout);
    }

    protected void createCardlayoutPrincipal() {
        cardlayoutPrincipal = new java.awt.CardLayout();
        $objectMap.put("cardlayoutPrincipal", cardlayoutPrincipal);
    }

    protected void createFieldCurrentRegion() {
        fieldCurrentRegion = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldCurrentRegion", fieldCurrentRegion);
        fieldCurrentRegion.setName("fieldCurrentRegion");
        fieldCurrentRegion.addItemListener((java.awt.event.ItemListener) jaxx.runtime.Util.getEventListener(java.awt.event.ItemListener.class, "itemStateChanged", $JPanel0, "doItemStateChanged__on__fieldCurrentRegion"));
    }

    protected void createFieldNewRegion() {
        fieldNewRegion = new javax.swing.JTextField();
        $objectMap.put("fieldNewRegion", fieldNewRegion);
        fieldNewRegion.setName("fieldNewRegion");
        fieldNewRegion.setColumns(15);
        fieldNewRegion.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JPanel0, "doKeyReleased__on__fieldNewRegion"));
    }

    protected void createInputPane() {
        inputPane = new javax.swing.JPanel();
        $objectMap.put("inputPane", inputPane);
        inputPane.setName("inputPane");
        inputPane.setLayout((getCardlayout()));
    }

    protected void createInputPanePrincipal() {
        inputPanePrincipal = new javax.swing.JPanel();
        $objectMap.put("inputPanePrincipal", inputPanePrincipal);
        inputPanePrincipal.setName("inputPanePrincipal");
        inputPanePrincipal.setLayout((getCardlayoutPrincipal()));
    }

    protected void createJButtonNewRegion() {
        JButtonNewRegion = new javax.swing.JButton();
        $objectMap.put("JButtonNewRegion", JButtonNewRegion);
        JButtonNewRegion.setName("JButtonNewRegion");
        JButtonNewRegion.setEnabled(false);
        JButtonNewRegion.setText(_("isisfish.input.newRegion"));
        JButtonNewRegion.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__JButtonNewRegion"));
    }

    protected void createMenu() {
        menu = new javax.swing.JMenuBar();
        $objectMap.put("menu", menu);
        menu.setName("menu");
    }

    protected void createNavigation() {
        navigation = new jaxx.runtime.swing.JAXXTree();
        $objectMap.put("navigation", navigation);
        navigation.setName("navigation");
        navigation.setRootVisible(true);
        navigation.setRowHeight(0);
        navigation.setSelectionRow(0);
    }

    protected void createNavigationSelectionModel() {
        navigationSelectionModel = new javax.swing.tree.DefaultTreeSelectionModel();
        $objectMap.put("navigationSelectionModel", navigationSelectionModel);
    }

    protected void createNavigationTreeCellRenderer() {
        navigationTreeCellRenderer =  new fr.ifremer.isisfish.ui.input.InputNavigationTreeCellRenderer(this);
        $objectMap.put("navigationTreeCellRenderer", navigationTreeCellRenderer);
    }

    protected void createNoneUI() {
        noneUI = new fr.ifremer.isisfish.ui.input.NoneUI();
        $objectMap.put("noneUI", noneUI);
        noneUI.removeDataBinding("$JPanel0.name");
        
        noneUI.setName("noneUI");
    }

    protected void createRegion() {
        region = null;
        $objectMap.put("region", region);
    }

    protected void createTreePanel() {
        treePanel = new javax.swing.JPanel();
        $objectMap.put("treePanel", treePanel);
        treePanel.setName("treePanel");
        treePanel.setLayout((new BorderLayout()));
        treePanel.setName("treePanel");
    }

}
