/* *##%
 * Copyright (C) 2005 - 2009
 *     Ifremer, Code Lutin, Cedric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.input;

import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Listener used to control InputUI tab panel switching.
 * 
 * Ask for 
 *
 * @author letellier
 * @version $Revision: 1312 $
 *
 * Last update: $Date: 2008-08-28 10:21:07 +0200 (jeu, 28 aoû 2008) $
 * by : $Author: sletellier $
 */
public class InputTabbedPaneListener implements ChangeListener {

    /** Class logger. */
    private static Log log = LogFactory.getLog(InputTabbedPaneListener.class);

    protected int cacheSelectedIndex = -1;

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane = (JTabbedPane) e.getSource();
        pane.removeChangeListener(this);
        int selectedIndex = pane.getSelectedIndex();
        if (cacheSelectedIndex != -1) {
            pane.setSelectedIndex(cacheSelectedIndex);
        }
        InputContentUI ui = (InputContentUI) pane.getSelectedComponent();
        if (closeUI(ui)) {
            pane.setSelectedIndex(selectedIndex);
        }
        ui = (InputContentUI) pane.getSelectedComponent();
        if (log.isDebugEnabled()) {
            log.debug("Final refresh " + ui);
        }
        
        // refresh can be broken
        // especially during new region creation
        // don't break refresh cycle
        try {
            ui.refresh();
        }
        catch (Exception eee) {
            if(log.isErrorEnabled()) {
                log.error("Error during UI refresh", eee);
            }
        }

        // method only called for tabbed UI
        // otherwise save.cancel buttons are active in last
        // refreshed ui
        if (log.isDebugEnabled()) {
            log.debug("Activating action buttons on " + ui);
        }
        ui.setActionButtons();

        cacheSelectedIndex = pane.getSelectedIndex();
        pane.addChangeListener(this);
        
        // bug suis les UI autre que nimbus
        // la selection des onglet ne se rafraichit pas tres bien
        pane.repaint();
    }

    /**
     * Ask you to save if modification are made.
     * 
     * @param currentUI current displayed UI
     * @return true to change tab
     */
    protected boolean closeUI(InputContentUI currentUI) {
        // by default, we says that component was successfully closed
        boolean exit = true;

        InputSaveVerifier verif = currentUI
                .getContextValue(InputSaveVerifier.class);
        int responce = verif.checkEdit();

        if (responce == JOptionPane.CANCEL_OPTION) {
            exit = false;
        }
        return exit;
    }
}
