package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import java.lang.reflect.Method;
import java.io.File;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.ui.input.formule.FormuleComboModel;
import org.apache.commons.lang.StringUtils;
import org.nuiton.topia.TopiaContext;

public class InputOneEquationUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUS29TRxSeGJwXhJhX1UWrpmAQCGkMLQ+pobRgktapeYiAhLCQGPseOwPXM5eZc5ObLKpK3VYVqy66ge67ZI+qLrvqtv+hqvgHPTP32tdOrGCRLO44Z75zzvfNnPl+/5cVrWGfPhVJwk2sUHaBr1x/+PBO8ym08CbYlpERasPSv4kCKzTYgaAft8hONuouvZKlV6q6G2kFaiB7sc5mLW6GYNcAENnxNKNlbWW1H15Motj0qvXJjKr26u1/hRfBD78VGEsiYnWYJCy8KytXsL/OCjJAdoQ6rYtKKFSHaBipOsRzzsWqobD2tujCc/Y9m6qzyUgYKobsxPhSfQ2fn0TISuWaimKsaoUEf1A7j6zSNly2DXSBVittW9o1HksuHZB7+B0FS89jgVKrB7Uo8uUmke1HSIhMyVHljj5P6Q8gmiAUsjPadLiKJWrFUUdS8AgMtSIOLeD3XWSJlOBmnnnQZd41moC46WKH8r1iKxRbW8jm88ZeZY6YamvTjUNAVh6lDlwzCZYvp7A8cT5LrAqEjjbbO5cshDSPEPSOA9mpXRv0cHmJo+VVf0U1RQgRyi0wF5B94semRfcoQyq0AzIgrXxfNEP4DNmHQ6NmN+jkud9zyJl+wnR5pS6aEH5Ok+YOLMmgadSBTuyUr7tNfUMnPWLDTdzD7CGG8zNyF92/5eGtmfLKjRhpAi7RGQzxSMMOdm4n+rILVIY3SdFdoSC8sl2Rjw5jJyGgsTMkZGAGN2TQAeTpFl/yS8bWOHLuKqzluSfkj3aiwYqGTogMp9TI7eMehVLjyKK+gI++/PHX9V9ev/mi5xKz1GNuCDJgavRqo3TopWsxn1pDjDKs3BLRYoPNpBPoHe/YAIHVLEwkqP5h/zJcGv9W2DVKLU7988efHzz5ex8rLLPZUItgWTh8jc3gmiGVOgyS6KuvPZODG9P0LTlOdKeg3J2SUR26GggUC02pAjruawmpPTagtk/hrxc/3fro54+v9BRPpIy2wXLVxUdsUqpQKvCOmJndSAc8EFmIA52b2iibm3Dr6Sh7M1/67/VR0ryBud2bSeyWJU/W/fpmzBouXN2lwtkxWEyTpwdgwOypzruY8LEqfEdP6mp6FwsCyc2bMcK1vVTcjdOF8Ti5z+P3rYBsTthntfZtjatiHYJdil3esyBX4X970OiYzAgAAA==";
    protected org.nuiton.topia.persistence.TopiaEntity bean;
    protected java.lang.String beanProperty;
    protected java.lang.Class clazz;
    protected org.nuiton.widget.editor.Editor editor;
    protected fr.ifremer.isisfish.entities.Formule formule;
    protected java.lang.String formuleCategory;
    protected jaxx.runtime.swing.JAXXComboBox formuleComboBox;
    protected fr.ifremer.isisfish.entities.Equation selectedEquation;
    protected java.lang.String text;
    private fr.ifremer.isisfish.ui.input.InputOneEquationUI $InputContentUI0 = this;
    private javax.swing.JButton $JButton5;
    private javax.swing.JButton $JButton6;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JPanel $JPanel7;
    private jaxx.runtime.swing.Table $Table2;
    private jaxx.runtime.swing.Table $Table4;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "formuleComboBox.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JButton5.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JButton6.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "editor.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.text");

    /* begin raw body code */
    protected DocumentListener listener;
    
    protected void start() {
       if (listener == null) {
            jaxx.runtime.Util.assignment(listener = new DocumentListener() {
    
                @Override
                public void insertUpdate(DocumentEvent e) {
                    setEquation();
                }
    
                @Override
                public void removeUpdate(DocumentEvent e) {
                    setEquation();
                }
    
                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            }, "listener", fr.ifremer.isisfish.ui.input.InputOneEquationUI.this);
        }
        setComboModel();
        editor.getCurrentEditor().addDocumentListener(listener);
    }
    
    /**
     * Get equation on entity.
     */
    protected Equation getEquation() {
        Equation result = null;
        try {
            // can be null in some uis
            // content is managed by caller, can do anythings here
            if (bean != null && beanProperty != null) {
                String localBeanProperty = StringUtils.capitalize(beanProperty);
                Method m = bean.getClass().getMethod("get" + localBeanProperty, null);
                result = (Equation)m.invoke(bean);
            }
        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Can't get equation", e);
            }
        }
        return result;
    }
    
    /**
     * Call setXXXContent on topia entity (convention).
     */
    protected void setEquation() {
        try {
            // can be null in some uis
            // content is managed by caller, can do anythings here
            if (bean != null && beanProperty != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Saving equation content (" + bean.getClass().getSimpleName() +
                        "#" + beanProperty + ")");
                }
                String localBeanProperty = StringUtils.capitalize(beanProperty);
                Method m = bean.getClass().getMethod("set" + localBeanProperty + "Content", String.class);
                m.invoke(bean, editor.getText());
            }
            else {
                if (log.isDebugEnabled()) {
                    log.debug("No bean property defined, skipping content saving");
                }
            }
        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Can't set equation content", e);
            }
        }
    }
    
    @Override
    public void refresh() {
    
        // TODO binding don't work
        if (getText() == null) {
            setText(_("isisfish.common.equation"));    
        }
    
        editor.getCurrentEditor().removeDocumentListener(listener);
        try {
            File equationContentFile = org.nuiton.util.FileUtil.getTempFile("", ".java");
            editor.open(equationContentFile);
        } catch (IOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't refresh editor", ex);
            }
        }
        if (formuleCategory != null) {
            // chatellier 20090526 (change to get combo selected on this equation)
            selectedEquation = getEquation();
            setComboModel();
            setFormule((Formule)formuleComboBox.getSelectedItem());
            setEditorText();
        }
        editor.getCurrentEditor().addDocumentListener(listener);
    }
    
    @Override
    public void setActionButtons() {
    
    }
    
    protected void setComboModel() {
        if (getBean() !=  null){
            TopiaContext isisContext = getBean().getTopiaContext();
            java.util.List<Formule> formules = null;
            if (formuleCategory != null) {
                formules = getAction().getFormules(isisContext, formuleCategory);
                FormuleComboModel formulesModel = new FormuleComboModel(formules);
                formuleComboBox.setModel(formulesModel);
                // fix default selection
                formuleComboBox.setSelectedItem(selectedEquation);
            }
        }
    }
    protected void saveModel() {
        getContextValue(InputAction.class).saveAsModel(formuleCategory, "Java", editor.getText());
        setComboModel();
        setInfoText(_("isisfish.message.saveModel.finished"));
    }
    
    /**
     * Open external editor, with equation documentation.
     */
    protected void openEditor() {
        Formule e = (Formule)formuleComboBox.getSelectedItem();
        if (e != null) {
            getContextValue(InputAction.class).openEditor(e.getCategory(), e.getName(), clazz, e.getContent(), editor);
        }
        else {
            getContextValue(InputAction.class).openEditor(formuleCategory, "new", clazz, editor.getText(), editor);
        }
    }
    protected void setEditorText() {
        if (getFormule() != null) {
            editor.setText(getFormule().getContent());
        }
        else {
            try {
                editor.open(org.nuiton.util.FileUtil.getTempFile("", ".java"));
            } catch (IOException e) {
                if (log.isErrorEnabled()) {
                  log.error("Open editor", e);
                }
            }
        }
    }
    
    /**
     * New formule selected, replace content.
     */
    protected void formuleChanged() {
        Formule selectedFormule = (Formule)formuleComboBox.getSelectedItem();
        setFormule(selectedFormule);
        setEditorText();
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public InputOneEquationUI() {
        super();
        $initialize();
    }

    public InputOneEquationUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource8);
            }
        } else if ("$JLabel3.text".equals($binding)) {
                addPropertyChangeListener("text", $DataSource9);
        
        } else if ("formuleComboBox.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else if ("$JButton5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("$JButton6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else if ("editor.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("$JLabel3.text".equals($dest)) {
            $JLabel3.setText(_(String.valueOf((getText()))));
            } else if ("formuleComboBox.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                formuleComboBox.setEnabled((isActif()));
            }
            } else if ("$JButton5.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JButton5.setEnabled((isActif() && formuleCategory != null));
            }
            } else if ("$JButton6.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JButton6.setEnabled((isActif() && clazz != null && formuleCategory != null));
            }
            } else if ("editor.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                editor.setEnabled((isActif()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource8);
            }
        } else if ("$JLabel3.text".equals($binding)) {
                removePropertyChangeListener("text", $DataSource9);
        
        } else if ("formuleComboBox.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else if ("$JButton5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("$JButton6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else if ("editor.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton5(java.awt.event.ActionEvent event) {
        saveModel();
    }

    public void doActionPerformed__on__$JButton6(java.awt.event.ActionEvent event) {
        openEditor();
    }

    public void doActionPerformed__on__formuleComboBox(java.awt.event.ActionEvent event) {
        formuleChanged();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public org.nuiton.topia.persistence.TopiaEntity getBean() {
        return bean;
    }

    public java.lang.String getBeanProperty() {
        return beanProperty;
    }

    public java.lang.Class getClazz() {
        return clazz;
    }

    public org.nuiton.widget.editor.Editor getEditor() {
        return editor;
    }

    public fr.ifremer.isisfish.entities.Formule getFormule() {
        return formule;
    }

    public java.lang.String getFormuleCategory() {
        return formuleCategory;
    }

    public jaxx.runtime.swing.JAXXComboBox getFormuleComboBox() {
        return formuleComboBox;
    }

    public fr.ifremer.isisfish.entities.Equation getSelectedEquation() {
        return selectedEquation;
    }

    public java.lang.String getText() {
        return text;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(org.nuiton.topia.persistence.TopiaEntity newValue) {
        org.nuiton.topia.persistence.TopiaEntity oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setBeanProperty(java.lang.String newValue) {
        java.lang.String oldValue = this.beanProperty;
        this.beanProperty = newValue;
        firePropertyChange("beanProperty", oldValue, newValue);
    }

    public void setClazz(java.lang.Class newValue) {
        java.lang.Class oldValue = this.clazz;
        this.clazz = newValue;
        firePropertyChange("clazz", oldValue, newValue);
    }

    public void setFormule(fr.ifremer.isisfish.entities.Formule newValue) {
        fr.ifremer.isisfish.entities.Formule oldValue = this.formule;
        this.formule = newValue;
        firePropertyChange("formule", oldValue, newValue);
    }

    public void setFormuleCategory(java.lang.String newValue) {
        java.lang.String oldValue = this.formuleCategory;
        this.formuleCategory = newValue;
        firePropertyChange("formuleCategory", oldValue, newValue);
    }

    public void setSelectedEquation(fr.ifremer.isisfish.entities.Equation newValue) {
        fr.ifremer.isisfish.entities.Equation oldValue = this.selectedEquation;
        this.selectedEquation = newValue;
        firePropertyChange("selectedEquation", oldValue, newValue);
    }

    public void setText(java.lang.String newValue) {
        java.lang.String oldValue = this.text;
        this.text = newValue;
        firePropertyChange("text", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JButton get$JButton5() {
        return $JButton5;
    }

    protected javax.swing.JButton get$JButton6() {
        return $JButton6;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JPanel get$JPanel7() {
        return $JPanel7;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $InputContentUI0.add($Table2);
        
        
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(formuleComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($Table4, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(editor, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $Table4.add($JButton5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JButton6, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JPanel7, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("$JLabel3.text");
        applyDataBinding("formuleComboBox.enabled");
        formuleComboBox.setRenderer((new fr.ifremer.isisfish.ui.input.formule.FormuleComboRenderer()));
        applyDataBinding("$JButton5.enabled");
        applyDataBinding("$JButton6.enabled");
        applyDataBinding("editor.enabled");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createText();
        createBean();
        createBeanProperty();
        createClazz();
        createFormule();
        createFormuleCategory();
        createSelectedEquation();
        
        listener = null;
        
        $Table2 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table2", $Table2);
        $Table2.setName("$Table2");
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        
        createFormuleComboBox();
        
        $Table4 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table4", $Table4);
        $Table4.setName("$Table4");
        
        $JButton5 = new javax.swing.JButton();
        $objectMap.put("$JButton5", $JButton5);
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("isisfish.common.saveModel"));
        $JButton5.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__$JButton5"));
        
        $JButton6 = new javax.swing.JButton();
        $objectMap.put("$JButton6", $JButton6);
        $JButton6.setName("$JButton6");
        $JButton6.setText(_("isisfish.common.openEditor"));
        $JButton6.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__$JButton6"));
        
        $JPanel7 = new javax.swing.JPanel();
        $objectMap.put("$JPanel7", $JPanel7);
        $JPanel7.setName("$JPanel7");
        
        createEditor();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    formuleComboBox.setModel(new DefaultComboBoxModel());
                    try {
                        editor.open(org.nuiton.util.FileUtil.getTempFile("", ".java"));
                    } catch (IOException e) {
                        if (log.isErrorEnabled()) {
                            log.error("Error on property change", e);
                        }
                    }
                }
                if (evt.getNewValue() != null) {
                    // chatellier 20090526 : force refresh in bean change ?
                    refresh();
                }
            }
        });start();
        $completeSetup();
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBeanProperty() {
        beanProperty = null;
        $objectMap.put("beanProperty", beanProperty);
    }

    protected void createClazz() {
        clazz = null;
        $objectMap.put("clazz", clazz);
    }

    protected void createEditor() {
        editor = new org.nuiton.widget.editor.Editor();
        $objectMap.put("editor", editor);
        editor.setName("editor");
        editor.setAskIfNotSaved(false);
    }

    protected void createFormule() {
        formule = null;
        $objectMap.put("formule", formule);
    }

    protected void createFormuleCategory() {
        formuleCategory = null;
        $objectMap.put("formuleCategory", formuleCategory);
    }

    protected void createFormuleComboBox() {
        formuleComboBox = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("formuleComboBox", formuleComboBox);
        formuleComboBox.setName("formuleComboBox");
        formuleComboBox.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__formuleComboBox"));
    }

    protected void createSelectedEquation() {
        selectedEquation = null;
        $objectMap.put("selectedEquation", selectedEquation);
    }

    protected void createText() {
        text = null;
        $objectMap.put("text", text);
    }

}
