/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.input;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JTree;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeCellRenderer;

/**
 * Extention du NavigationTreeCellRenderer qui regle le probleme
 * des noeuds tronqués par des ...
 *
 * @author chatellier
 * @version $Revision: 2465 $
 * 
 * Last update : $Date: 2009-07-06 11:18:31 +0200 (lun., 06 juil. 2009) $
 * By : $Author: chatellier $
 */
public class InputNavigationTreeCellRenderer extends NavigationTreeCellRenderer {

    /**
     * Constructor with context.
     * 
     * @param context jaxx context
     */
    public InputNavigationTreeCellRenderer(JAXXContext context) {
        super(context);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value,
            boolean sel, boolean expanded, boolean leaf, int row,
            boolean hasFocus) {

        Component c = super.getTreeCellRendererComponent(tree, value, sel,
                expanded, leaf, row, hasFocus);

        // bugfix from http://forums.sun.com/thread.jspa?forumID=256&threadID=277338
        // hack from : http://forums.sun.com/thread.jspa?threadID=542069&tstart=824

        if (delegate.getPreferredSize().getWidth() < 300) {
            delegate.setPreferredSize(new Dimension(300, (int) delegate
                    .getPreferredSize().getHeight()));
        }

        return c;
    }
}
