package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import javax.swing.JComponent;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI;
import fr.ifremer.isisfish.ui.sensitivity.EditorHelper;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabbedPaneListener;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import org.nuiton.topia.persistence.TopiaEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InputContentUI extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.input.InputContentUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Tz2sTQRSexCZp0h9WWxVEoVpPChstQsGK2kaKKakW20IxFye7k2bqZmeceZtuLiJ4FenJgxf17tG7iEdPXv0fRPwPfLO7yW4ltQHNYXfz9r1vvu/t9334QXJakQu7NAgs5XvA28xaXdreftDYZTbcZdpWXIJQJPplsiRbJ2NOv66BzNVrZrwcj5croi2Fx7zU9GKNlDR0XaZbjAGQU9GErXV5o19eDKSvemh9MoPQ3v36md13nr/PEhJIZFVCCbNHTSUKRmokyx0gJ/GkDi271NtBGop7O8hzwtQqLtX6Pm2zp+QZKdRIXlKFYEAuDi81xAjnAwlk9NLqOvWYexXIlaayeFOxNsO75rrJdcvyucU96YNVNdeK8ABRt6pShhB5IDlqA28COWH4WYaztSyEy6iX9Ixp5mkOvMOha0qTqVcNH0B4mxxcBmQqAYmEJ42jHgtgnULL/J9O6gWXdpnaquIODmxa73FDxRX2E3yoRU0puHhsHn1y9Nx8MjgOtOGyWu/QhUOWllJsbZqJQ5mMNITTxY9upAfx8dE3MQ3FpM8sAMj0gb7lcHtxozIvUQra10rsm/grUyc55WMZF11PnP4QS5HH42oIEFbfvnjTef3x042eoQt4xsSBllT+0GBSCckUcHPE8cjFPnC3vEblYp0UNXMxvGE4Z1IENuIykkD8yEhmzLpHdQtHc4Xvn7+cfvztGMmukJIrqLNCTX+VFKGlUKVwnUDevhMyGd8bxeuU4QQkj19Z4IrI5E2HAp1tcM/Bvd0KUOxMSmyfwdf9l2vnXp1f6AnORIT+aEtE5x6RPPdc7rEwu3EsB2Z1TGrmOyKJ36BAZsy9JGN3XA6v1iBlE43YTxXhCmXargW+uc2HrM3T9RDszBBg49S2mYQlTHJkpkOwzg6BVYqwqvY/IxVDif8BaAQwOX/BmBsCo9DBdGOMj4D5DZIl5zm4BgAA";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.lang.Boolean actif;
    protected javax.swing.JPanel body;
    protected java.lang.String buttonTitle;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected jaxx.runtime.swing.BlockingLayerUI layerUI;
    protected jaxx.runtime.swing.BlockingLayerUI2 layerUI2;
    protected javax.swing.JButton next;
    protected java.lang.String nextPath;
    protected java.lang.Boolean sensitivity;
    protected fr.ifremer.isisfish.ui.sensitivity.TableBlockingLayerUI tableLayerUI;
    private fr.ifremer.isisfish.ui.input.InputContentUI $JPanel0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($JPanel0, "next.text");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($JPanel0, "next.visible");

    /* begin raw body code */
    protected ChangeListener tabbedPaneChangeListener;
    
    
    /**
     * This method is UI entry point.
     *
     * It's called :
     *  - by input tree to first display UI
     *  - by input verifier on cancel action
     * 
     * 20090602 chatellier : make abstract, must be implemented !
     */
    public abstract void refresh();
    
    /**
     * This is a hack for tabbed UI.
     *
     * In this case of UI, they have multiples save/cancel
     * buttons, they have to be manually activated
     * on tab siwtching.
     */
    public abstract void setActionButtons();
    
    public InputAction getAction() {
        return getContextValue(InputAction.class);
    }
    public InputSaveVerifier getVerifier() {
        return getContextValue(InputSaveVerifier.class);
    }
    public FisheryRegion getRegion() {
        return getContextValue(FisheryRegion.class);
    }
    public void setInfoText(String msg) {
        WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
        if (root != null){
            root.setStatusMessage(msg);
        }
    }
    protected void goTo() {
        getParentContainer(InputUI.class).setTreeSelection(getNextPath());
    }
    
    /**
     * Mettre a jour la region dans une map si necessaire.
     *
     * @param map la map a mettre a jour si necessaire
     */
    protected void refreshRegionInMap(fr.ifremer.isisfish.map.IsisMapBean map) {
        FisheryRegion fisheryRegion = map.getFisheryRegion();
        FisheryRegion regionFromContext = getRegion();
        if (fisheryRegion == null || !fisheryRegion.equals(regionFromContext)) {
            if (log.isInfoEnabled()) {
                log.info("Use now " + regionFromContext + " in map " + map);
            }
            map.setFisheryRegion(regionFromContext);
        }
    }
    
    public void setLayer(boolean active) {
        if (this.get$objectMap() != null && active) {
            for (JComponent boxed : SwingUtil.getLayeredComponents(this)) {
                // Verifie si dans l'entré existe dans le fichier sensitivity.properties
                Class classBean = (Class)boxed.getClientProperty("bean");
                String method = (String)boxed.getClientProperty("method");
    
                // test if factor is enabled
                boolean isSensitivityFactorEnabled = false;
                if (classBean != null) {
                    // classBean is defined in property file without "Impl"
                    String className = classBean.getSimpleName().replace("Impl", "");
    
                    // ensure that method name is uncapitalized
                    method = StringUtils.uncapitalize(method);
    
                    String sensitivityFactorName = className + "." + method;
                    isSensitivityFactorEnabled = SensitivityUtils.isSensitivityFactorEnabled(sensitivityFactorName);
                }
                
                // install correct layer depending if factor enable
                if (isSensitivityFactorEnabled) {
                    jaxx.runtime.swing.BlockingLayerUI2 ui = layerUI2.clone();
                    SwingUtil.getLayer(boxed).setUI(ui);
                } else {
                    if (boxed instanceof JTable) {
                        //fr.ifremer.isisfish.ui.sensitivity.TableBlockingLayerUI layerui =
                        //    new fr.ifremer.isisfish.ui.sensitivity.TableBlockingLayerUI();
                        //layerui.parent = this;
                        //layerui.verifier = getVerifier();
                        SwingUtil.getLayer(boxed).setUI(tableLayerUI);
                    }
                    else {
                        jaxx.runtime.swing.BlockingLayerUI ui = layerUI.clone();
                        ui.setBlock(true);
                        ui.setUseIcon(isActif());
                        SwingUtil.getLayer(boxed).setUI(ui);
                    }
                }
            }
        }
    }
    
    /**
     * Action appelée lors du clic sur un layer.
     * 
     * @param e l'event initial intersepté par le layer
     */
    protected void accept(ActionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("Event intercepted on " + e);
        }
    
        JComponent source = (JComponent) e.getSource();
        Class<? extends TopiaEntity> classBean = (Class<? extends TopiaEntity>)source.getClientProperty("bean");
        String beanID = (String)source.getClientProperty("beanID");
        /*TopiaEntity bean = null;
        if (beanID == null) {
            bean = getVerifier().getEntity(classBean);
        }
        else {
            bean = getVerifier().getEntity(classBean, beanID);
        }
        if (bean != null) {
            FactorWizardUI wizard = new FactorWizardUI(this);
            wizard.initNew(source, bean, EditorHelper.canBeContinue(source, bean));
            wizard.pack();
            wizard.setVisible(true);
        }*/
        
        String property = (String)source.getClientProperty("method");
        displayFactorWizard(source, classBean, beanID, property);
    }
    
    /**
     * Display factor wizard for bean/property in registred in verifier.
     */
    public void displayFactorWizard(JComponent source, Class<? extends TopiaEntity> classBean, String beanID, String property) {
    
        if (log.isDebugEnabled()) {
            log.debug("Event intercepted " + source);
            log.debug(" client property (bean) : " + classBean);
            log.debug(" client property (beanID) : " + beanID);
            log.debug(" client property (method) : " + property);
        }
    
        TopiaEntity bean = null;
        if (beanID == null) {
            bean = getVerifier().getEntity(classBean);
        }
        else {
            bean = getVerifier().getEntity(classBean, beanID);
        }
        
        if (bean != null) {
        
            JComponent editor = source;
            
            // This is a special case for table source component
            // If current entity is displayed by a JTable component
            // we need to find a better component than
            // can display 'property' on 'bean'
            if (editor instanceof JTable) {
                editor = EditorHelper.getEditorForValue(bean, property);
            }
    
            if (editor != null) {
                FactorWizardUI wizard = new FactorWizardUI(this);
                wizard.initNew(editor, bean, EditorHelper.canBeContinue(editor, bean));
                wizard.pack();
                wizard.setVisible(true);
            }
            else if (log.isWarnEnabled()) {
                log.warn("Can't find editor for " + classBean.getSimpleName() + "#" + property);
            }
        }
        else {
            if (log.isErrorEnabled()) {
                log.error("Can't find bean in current verifier (classBean = " + classBean + ", beanID = " + beanID + ")");
            }
        }
    }
    
    /**
     * Install tabbed pane change listener depending on sensitivity.
     * (init at first call)
     *
     * @param tabbedPane tabbed pane to install change listener
     */
    protected void installChangeListener(JTabbedPane tabbedPane) {
    
        // remove already registred listeners
        for (ChangeListener changeListener : tabbedPane.getChangeListeners()) {
            tabbedPane.removeChangeListener(changeListener);
        }
    
        if (tabbedPaneChangeListener == null) {
            if (isSensitivity()) {
                jaxx.runtime.Util.assignment(tabbedPaneChangeListener = new SensitivityTabbedPaneListener(), "tabbedPaneChangeListener", fr.ifremer.isisfish.ui.input.InputContentUI.this);
            } else {
                jaxx.runtime.Util.assignment(tabbedPaneChangeListener = new InputTabbedPaneListener(), "tabbedPaneChangeListener", fr.ifremer.isisfish.ui.input.InputContentUI.this);
            }
        }
    
        tabbedPane.addChangeListener(tabbedPaneChangeListener); 
    }
    
    /**
     * Active les boutons sur l'onglet actuellement affiché.
     */
    protected void setCurrentTabActionButtons(JTabbedPane tabbedPane) {
        InputContentUI selectedUI = (InputContentUI) tabbedPane.getSelectedComponent();
        selectedUI.setActionButtons();
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public InputContentUI() {
        $initialize();
    }

    public InputContentUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("next.text".equals($binding)) {
                addPropertyChangeListener("buttonTitle", $DataSource6);
        
        } else if ("next.visible".equals($binding)) {
                addPropertyChangeListener("nextPath", $DataSource7);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("next.text".equals($dest)) {
            next.setText(_(String.valueOf((getButtonTitle()))));
            } else if ("next.visible".equals($dest)) {
            next.setVisible((getNextPath() != null));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("next.text".equals($binding)) {
                removePropertyChangeListener("buttonTitle", $DataSource6);
        
        } else if ("next.visible".equals($binding)) {
                removePropertyChangeListener("nextPath", $DataSource7);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__next(java.awt.event.ActionEvent event) {
        goTo();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public java.lang.Boolean getActif() {
        return actif;
    }

    public javax.swing.JPanel getBody() {
        return body;
    }

    public java.lang.String getButtonTitle() {
        return buttonTitle;
    }

    public jaxx.runtime.swing.BlockingLayerUI getLayerUI() {
        return layerUI;
    }

    public jaxx.runtime.swing.BlockingLayerUI2 getLayerUI2() {
        return layerUI2;
    }

    public javax.swing.JButton getNext() {
        return next;
    }

    public java.lang.String getNextPath() {
        return nextPath;
    }

    public java.lang.Boolean getSensitivity() {
        return sensitivity;
    }

    public fr.ifremer.isisfish.ui.sensitivity.TableBlockingLayerUI getTableLayerUI() {
        return tableLayerUI;
    }

    public java.lang.Boolean isActif() {
        return actif !=null && actif;
    }

    public java.lang.Boolean isSensitivity() {
        return sensitivity !=null && sensitivity;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setActif(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.actif;
        this.actif = newValue;
        firePropertyChange("actif", oldValue, newValue);
    }

    public void setButtonTitle(java.lang.String newValue) {
        java.lang.String oldValue = this.buttonTitle;
        this.buttonTitle = newValue;
        firePropertyChange("buttonTitle", oldValue, newValue);
    }

    public void setNextPath(java.lang.String newValue) {
        java.lang.String oldValue = this.nextPath;
        this.nextPath = newValue;
        firePropertyChange("nextPath", oldValue, newValue);
    }

    public void setSensitivity(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.sensitivity;
        this.sensitivity = newValue;
        firePropertyChange("sensitivity", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.InputContentUI get$JPanel0() {
        return $JPanel0;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JPanel0.add(body, BorderLayout.CENTER);
        $JPanel0.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(next), BorderLayout.SOUTH);
        
        layerUI.setBlockingColor((new Color(25,25,25)));
        layerUI2.setAcceptAction((new AbstractAction() {              private static final long serialVersionUID = 1L;              @Override              public void actionPerformed(ActionEvent e) {                 accept(e);              }          }));
        layerUI2.setAcceptIcon((SwingUtil.createImageIcon("building_add.png")));
        layerUI2.setBlockIcon((SwingUtil.createImageIcon("building.png")));
        applyDataBinding("next.text");
        applyDataBinding("next.visible");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createActif();
        createSensitivity();
        createButtonTitle();
        createNextPath();
        createLayerUI();
        createLayerUI2();
        createTableLayerUI();
        createBody();
        createNext();
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout((new BorderLayout()));
        
        
        $completeSetup();
    }

    protected void createActif() {
        actif = false;
        $objectMap.put("actif", actif);
    }

    protected void createBody() {
        body = new javax.swing.JPanel();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createButtonTitle() {
        buttonTitle = "";
        $objectMap.put("buttonTitle", buttonTitle);
    }

    protected void createLayerUI() {
        layerUI = new jaxx.runtime.swing.BlockingLayerUI();
        $objectMap.put("layerUI", layerUI);
    }

    protected void createLayerUI2() {
        layerUI2 = new jaxx.runtime.swing.BlockingLayerUI2();
        $objectMap.put("layerUI2", layerUI2);
    }

    protected void createNext() {
        next = new javax.swing.JButton();
        $objectMap.put("next", next);
        next.setName("next");
        next.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__next"));
    }

    protected void createNextPath() {
        nextPath = null;
        $objectMap.put("nextPath", nextPath);
    }

    protected void createSensitivity() {
        sensitivity = false;
        $objectMap.put("sensitivity", sensitivity);
    }

    protected void createTableLayerUI() {
        tableLayerUI =  new fr.ifremer.isisfish.ui.sensitivity.TableBlockingLayerUI(this);
        $objectMap.put("tableLayerUI", tableLayerUI);
    }

}
