/* *##%
 * Copyright (C) 2006 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

/**
 * WelcomeSaveVerifier.
 * 
 * @author letellier
 * @version $Revision: 2297 $
 *
 * Last update: $Date: 2009-06-02 10:50:14 +0200 (mar., 02 juin 2009) $
 * by : $Author: chatellier $
 */
public class WelcomeSaveVerifier {

    /** Save verifier list. */
    protected List<SaveVerifier> verifiers = new ArrayList<SaveVerifier>();

    /**
     * Add new verifier to manage.
     * 
     * @param saveVerifier new verifier
     */
    public void addSaveVerifier(SaveVerifier saveVerifier) {
        verifiers.add(saveVerifier);
    }

    /**
     * Check that all 'input' opened interface has no non-saved modification.
     * 
     * @return <tt>true> if interface can be closed
     */
    public boolean allIsSaved() {
        boolean canExit = true;

        for (SaveVerifier s : verifiers) {
            int reponse = s.checkEdit();

            // return false, if at least one verifier
            // return cancel option
            if (reponse == JOptionPane.CANCEL_OPTION) {
                canExit = false;
            }
        }

        return canExit;
    }

}
