/* *##%
 * Copyright (C) 2006 - 2009
 *     Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

/* *
 * TimeUnit.java
 *
 * Created: 20 janv. 2006 03:03:15
 *
 * @author poussin
 * @version $Revision: 2658 $
 *
 * Last update: $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
 * by : $Author: chatellier $
 */

package fr.ifremer.isisfish.types;

import static org.nuiton.i18n.I18n._;

import java.io.Serializable;


/**
 * @author poussin
 *
 */

public class TimeUnit implements Cloneable, Serializable, Comparable<TimeUnit> {
    
    static public final double HOUR_PER_DAY = 24;
    
    /**  */
    private static final long serialVersionUID = 1L;
    
    /** le temps en seconde */
    protected double time; 
    
    /**
     * @param time le temps en seconde
     */
    public TimeUnit(double time) {
        this.time = time;
    }
    
    
    /**
     * @return Returns the time in second
     */
    public double getTime() {
        return this.time;
    }
    
    /**
     * @param time The time to set in second
     */
    public TimeUnit setTime(double time) {
        this.time = time;
        return this;
    }
    
    public double getHour() {
        return time / 60.0 / 60.0;
    }
    
    public TimeUnit setHour(double hour) {
        this.time = hour * 60.0 * 60.0;
        return this;
    }
    
    public double getDay() {
        return getHour() / 24.0;
    }
    
    public TimeUnit setDay(double day) {
        setHour(day * 24.0);
        return this;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Comparable#compareTo(T)
     */
    public int compareTo(TimeUnit o) {
        if (time < o.time) {
            return -1;
        } else if (time > o.time) {
            return 1;
        } else {
            return 0;
        }
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = "";
        if (getDay() >= 1) {
            result += getDay() + _("isisfish.timeUnit.day");
        } else {
            result += getHour() + _("isisfish.timeUnit.hours");
        }
        return result;
        
    }

}


