/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.simulator.sensitivity;

import java.io.File;
import java.util.List;

import org.nuiton.topia.TopiaContext;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import org.nuiton.topia.TopiaContext;

/**
 * Interface commune à toutes implémentation de calcul de sensibilité.
 * 
 * Les implémentations peuvent contenir des paramètres nommé "param_xx" (pour le
 * paramètre xx) qui seront injecté par Isis.
 * 
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 19 févr. 2009 $ By : $Author: chatellier $
 */
public interface SensitivityCalculator {

    /**
     * Set topia context on current region to nominal value compute.
     * 
     * @param context context
     */
    void setTopiaContext(TopiaContext context);

    /**
     * Return calculator description.
     * 
     * @return calculator description
     */
    String getDescription();

    /**
     * Retourne vrai si le calculateur sait gerer la cardinalité
     * des facteurs continue.
     * 
     * @return <tt>true</tt> s'il sait la gerer
     */
    boolean canManageCardinality();
    
    /**
     * Envoi un plan a faire analyser par l'outils d'analyse de sensibilité.
     * 
     * Retourne un {@link SensitivityScenarios} qui représente l'ensemble des
     * scenarios à prendre en compte pour les simulations.
     * 
     * @param plan plan a analyser
     * @param outputdirectory master sensitivity export directory
     * 
     * @return un {@link SensitivityScenarios}
     * @throws SensitivityException if calculator impl fail to execute
     * 
     * @see DesignPlan
     * @see Scenario
     * @see SensitivityScenarios
     */
    SensitivityScenarios compute(DesignPlan plan, File outputdirectory)
            throws SensitivityException;

    /**
     * Permet de renvoyer les resultats de simulations à l'outils de d'analyse
     * de sensibilité.
     * 
     * @param simulationStorages
     *            ensemble des {@link SimulationStorage} qui ont résultés des
     *            simulations
     * @param outputdirectory master sensitivity export directory
     * @throws SensitivityException
     *             if calculator impl fail to execute
     * 
     * @see SensitivityScenarios
     */
    void analyzeResult(List<SimulationStorage> simulationStorages,
            File outputdirectory) throws SensitivityException;
}
