/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.simulator.sensitivity;

import java.io.Serializable;

import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.DomainVisitor;

/**
 * Domaine du facteur.
 * 
 * Ensemble des valeurs possibles a prendre en compte.
 * La clé est un label qui permet d'identifier la valeur.
 * 
 * Le domain peut etre :
 *  - discret : i.e un ensemble de valeurs
 *  - continu : i.e, une borne min, max
 *
 * @param <E> type des valeurs gérées par le domaine
 * @param <F> type des labels
 * 
 * @see DiscreteDomain
 * @see ContinuousDomain
 * 
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 24 févr. 2009 $
 * By : $Author: chatellier $
 */
public interface Domain<E extends Serializable, F extends Serializable> extends Serializable {

    /**
     * Return value associated to identifier.
     * 
     * @param identifier
     * @return found value or <tt>null</tt> if not found
     */
    E getValueForIdentifier(F identifier);
    
    /**
     * Accept a new visitor.
     * 
     * @param visitor
     */
    public void accept(DomainVisitor visitor);
    
    /**
     * Clone the domain
     * 
     * @return the domain cloned
     */
    
    public Domain<E, F> clone();
}
