/* *##%
 * Copyright (C) 2007
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

/* *
 * SimulationResultGetter.java
 *
 * Created: 13 nov. 07 12:00:14
 *
 * @author poussin
 * @version $Revision: 2658 $
 *
 * Last update: $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
 * by : $Author: chatellier $
 */

package fr.ifremer.isisfish.simulator;

import org.nuiton.math.matrix.MatrixND;

import fr.ifremer.isisfish.types.Date;


/**
 * Some SimulationResultListener can implement this interface to show that can
 * be used to retrieve result
 * 
 * @author poussin
 */
public interface SimulationResultGetter {

    /**
     * Retourne la matrice stocke pour un pas de temps
     * @param date le pas de temps que l'on souhaite
     * @param name le nom des resultats dont on veut la matrice
     * @return La matrice demandée ou null si aucune matrice ne correspond a
     * la demande.
     */
     public MatrixND getMatrix(SimulationContext context, Date date, String name);
     
     /**
      * Retourne une matrice contenant tous les pas de temps.
      * @param name le nom des resultats dont on veut une matrice globale.
      */
     public MatrixND getMatrix(SimulationContext context, String name);
     
}


