/* *##%
 * Copyright (C) 2007 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.simulator;

import static org.nuiton.i18n.I18n._;

import org.nuiton.topia.TopiaContext;

import fr.ifremer.isisfish.datastore.SimulationStorage;

import bsh.Interpreter;

/**
 * SimulationPreScript.
 * 
 * Created: 14 nov. 07 00:06:18
 *
 * @author poussin
 * @version $Revision: 2658 $
 *
 * Last update: $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
 * by : $Author: chatellier $
 */
public class SimulationPreScript implements SimulationListener {

    /*
     * @see fr.ifremer.isisfish.simulator.SimulationListener#afterSimulation(fr.ifremer.isisfish.simulator.SimulationContext)
     */
    @Override
    public void afterSimulation(SimulationContext context) {
    }

    /*
     * @see fr.ifremer.isisfish.simulator.SimulationListener#beforeSimulation(fr.ifremer.isisfish.simulator.SimulationContext)
     */
    @Override
    public void beforeSimulation(SimulationContext context) {
        try {
            context.message(_("isisfish.message.presimulation.script.execution"));

            SimulationStorage simulation = context.getSimulationStorage();
            SimulationParameter parameters = simulation.getParameter();
            String presimulationScript = parameters.getPreScript();
            if ((parameters.getUsePreScript() || parameters.getUseAnalysePlan())
                    && presimulationScript != null
                    && !"".equals(presimulationScript)) {

                // utilisation de la db en memoire que l'on commitera
                TopiaContext tx = context.getDB();

                Interpreter bsh = new Interpreter();
                bsh.set("context", context);
                bsh.set("db", tx);
                bsh.eval("import org.nuiton.topia.*;");
                bsh.eval("import org.nuiton.topia.persistence.*;");
                bsh.eval("import fr.ifremer.isisfish.*;");
                bsh.eval("import java.util.*;");
                bsh.eval("import fr.ifremer.isisfish.types.*;");
                bsh.eval("import fr.ifremer.isisfish.types.Date;");
                bsh.eval("import fr.ifremer.isisfish.entities.*;");
                bsh.eval(presimulationScript);

                tx.commitTransaction();
            }
        } catch (Exception eee) {
            throw new SimulationException(
                    _("Can't evaluate simulation prescript"), eee);
        }
    }
}
