/* *##%
 * Copyright (C) 2007
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

/* *
 * SimulationListener.java
 *
 * Created: 13 nov. 07 12:37:55
 *
 * @author poussin
 * @version $Revision: 1526 $
 *
 * Last update: $Date: 2008-10-07 18:46:13 +0200 (mar., 07 oct. 2008) $
 * by : $Author: tchemit $
 */

package fr.ifremer.isisfish.simulator;



/**
 * You can create new SimulationListener and add it for simulation. To do that
 * add tag/value in advanced parameter simulation launcher like
 * 
 * tag: SimulationListener
 * value: fr.ifremer.simulator.SimulationResultXML(outFilename="/tmp/export-isis/mexico.xml"), ...
 * 
 * @author poussin
 */
public interface SimulationListener {

    /**
     * called before simulation
     * 
     * @param context
     */
    public void beforeSimulation(SimulationContext context);

    /**
     * called after simulation
     * 
     * @param context
     */
    public void afterSimulation(SimulationContext context);
    
}


