/* *##%
 * Copyright (C) 2007 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.simulator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.ExportHelper;
import fr.ifremer.isisfish.export.SensitivityExport;

/**
 * Export simulation listener.
 * 
 * Do export after simulation ends.
 *
 * Created: 14 nov. 07 00:22:51
 *
 * @author poussin
 * @version $Revision: 2595 $
 *
 * Last update: $Date: 2009-09-10 11:05:38 +0200 (jeu., 10 sept. 2009) $
 * by : $Author: chatellier $
 */
public class SimulationExportResultWrapper implements SimulationListener {

    /** Class logger. */
    private static Log log = LogFactory
            .getLog(SimulationExportResultWrapper.class);

    /*
     * @see fr.ifremer.isisfish.simulator.SimulationListener#afterSimulation(fr.ifremer.isisfish.simulator.SimulationContext)
     */
    @Override
    public void afterSimulation(SimulationContext context) {
        SimulationStorage simulation = context.getSimulationStorage();
        SimulationParameter parameters = simulation.getParameter();
        File rootDirectory = simulation.getDirectory();

        // Ici on contantene les 2 listes d'exports
        
        // first, make export instances based on export
        // names
        List<Export> allExports = new ArrayList<Export>();
        if (parameters.getExportNames() != null) {
            for (String exportName : parameters.getExportNames()) {
                try {
                    ExportStorage storage = ExportStorage.getExport(exportName);
                    Export export = storage.getNewExportInstance();
                    allExports.add(export);
                } catch (IsisFishException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't get export instance " + exportName, e);
                    }
                }
            }
        }
        
        // second, add already instanciated sensitivity
        // exports (with parameters)
        List<SensitivityExport> sensitivityExports = parameters.getSensitivityExport();
        if (sensitivityExports != null) {
            allExports.addAll(sensitivityExports);
        }
        
        // make exports
        if (!allExports.isEmpty()) {
            File exportDir = SimulationStorage
                    .getResultExportDirectory(rootDirectory);
            exportDir.mkdirs();
            ExportHelper.doExport(simulation, exportDir, allExports,
                    rootDirectory);
        }
    }

    /*
     * @see fr.ifremer.isisfish.simulator.SimulationListener#beforeSimulation(fr.ifremer.isisfish.simulator.SimulationContext)
     */
    @Override
    public void beforeSimulation(SimulationContext context) {
    }
}
