/* *##%
 * Copyright (C) 2007 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.simulator;

import java.util.HashMap;
import java.util.Map;

import fr.ifremer.isisfish.datastore.SimulationStorage;

/**
 * AnalysePlanContext.java
 *
 * Created: 1 mars 07 20:19:31
 *
 * @author poussin
 * @version $Revision: 2682 $
 *
 * Last update: $Date: 2009-10-21 14:18:45 +0200 (mer., 21 oct. 2009) $
 * by : $Author: chatellier $
 */
public class AnalysePlanContext {

    /** Simulation id. */
    protected String id;

    /** Analyse plan number. */
    protected int number = 0;

    /** Simulation parameters. */
    protected SimulationParameter param;

    /** Additionnal context values. */
    protected Map<String, Object> values = new HashMap<String, Object>();

    public AnalysePlanContext(String id, SimulationParameter param) {
        this.id = id;
        this.param = param;
    }

    /**
     * Get id.
     * 
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * Get current analyze plan simulation count.
     * 
     * Warning, in after simulation, refer to generated simulation count,
     * not ended simulation number.
     * Depreciated, but no remove this method, it's just to not be used
     * by user script.
     * 
     * @return the number
     * 
     * @deprecated use {@code nextSimulation.getParameter().getAnalysePlanNumber()}
     */
    public int getNumber() {
        return number;
    }

    /**
     * Must be call when new simulation is generated from plan.
     */
    public void incNumber() {
        number++;
    }

    /**
     * Get simulation parameters.
     * 
     * @return simulation parameters
     */
    public SimulationParameter getParam() {
        return param;
    }

    /**
     * Get plan context value.
     * 
     * Used in script.
     * 
     * @param key key
     * @return value for key.
     */
    public Object getValue(String key) {
        return this.values.get(key);
    }

    /**
     * Set plan context value.
     * 
     * Used in script.
     * 
     * @param key key
     * @param value value
     */
    public void setValue(String key, Object value) {
        this.values.put(key, value);
    }

    /**
     * Get last simulation storage.
     * 
     * Used in script.
     * 
     * @return last simulation storage
     */
    public SimulationStorage getLastSimulation() {
        SimulationStorage result = getSimulation(getNumber() - 1);
        return result;
    }

    /**
     * Get {@link SimulationStorage} for specified analyse plan number.
     * 
     * @param number number
     * @return {@link SimulationStorage}
     */
    public SimulationStorage getSimulation(int number) {
        SimulationStorage result = null;
        if (0 <= number && number <= getNumber()) {
            result = SimulationStorage.getSimulation(id + "_" + number);
        }
        return result;
    }
}
