/* *##%
 * Copyright (C) 2009 Ifremer, Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.SensitivityScenariosVisitor;

/**
 * XML sensitivity scenarios visitor.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public class SensitivityScenariosXMLVisitor implements SensitivityScenariosVisitor {

    /** XML text buffer. */
    protected StringBuffer xmlBuffer;

    /**
     * Constructor.
     * 
     * Init xml buffer.
     */
    public SensitivityScenariosXMLVisitor() {
        xmlBuffer = new StringBuffer();
    }

    /**
     * Get xml buffer content.
     * 
     * @return content as string
     */
    public String getXML() {
        String xml = xmlBuffer.toString();
        return xml;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void start(SensitivityScenarios scenarios) {
        xmlBuffer.append("<experimentalScenarios>");
        xmlBuffer.append("<scenarios>");
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public void visit(SensitivityScenarios scenarios, Scenario scenario) {
        ScenarioXMLVisitor visitor = new ScenarioXMLVisitor();
        scenario.accept(visitor);
        xmlBuffer.append(visitor.getXML());
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public void end(SensitivityScenarios scenarios) {
        xmlBuffer.append("</scenarios>");
        xmlBuffer.append("</experimentalScenarios>");
    }
}
