/* *##%
 * Copyright (C) 2009-2010 Ifremer, Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;

/**
 * XML domain visitor for Matrix continuous.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public class MatrixContinuousDomainXMLVisitor extends ContinuousDomainXMLVisitor {

    /**
     * {@inheritDoc}
     */
    @Override
    public void start(Domain domain) {
        super.start(domain);

        MatrixContinuousDomain mDomain = (MatrixContinuousDomain)domain;
        // since 3.3.0.0 coefficient element is outside matrix element
        xmlBuffer.append("<coefficient value=\"" + mDomain.getCoefficient() + "\" operator=\"" + mDomain.getOperator() + "\" />");
        xmlBuffer.append(MexicoHelper.getMatrixAsXML(mDomain.getMatrix()));
    }
}
