/* *##%
 * Copyright (C) 2009 Ifremer, Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;

/**
 * XML domain visitor for Equation Continous Domain.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 30 mars 2009 $
 * By : $Author: chatellier $
 */
public class EquationContinuousDomainXMLVisitor extends ContinuousDomainXMLVisitor {

    /**
     * {@inheritDoc}
     */
    @Override
    public void start(Domain domain) {
        super.start(domain);

        EquationContinuousDomain eDomain = (EquationContinuousDomain)domain;
        // since 3.3.0.0 coefficient element is outside equation element
        xmlBuffer.append("<coefficient value=\"" + eDomain.getCoefficient() + "\" operator=\"" + eDomain.getOperator() + "\" />");
        xmlBuffer.append("<equation variable=\"" + eDomain.getVariableName()+ "\"");
        xmlBuffer.append(" reference=\"" + eDomain.getReferenceValue() + "\" />");
    }
}
