/* *##%
 * Copyright (C) 2009 Ifremer, Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.mexico.xml;

import java.io.Serializable;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;

/**
 * XML domain visitor.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public class ContinuousDomainXMLVisitor extends DomainXMLVisitor {

    /**
     * {@inheritDoc}
     */
    @Override
    public void start(Domain domain) {
        xmlBuffer.append("<domain>");
        xmlBuffer.append("<fixed");

        ContinuousDomain cDomain = (ContinuousDomain)domain;
        xmlBuffer.append(" cardinality=\"" + cDomain.getCardinality() + "\">");

        xmlBuffer.append("<range min=\"" + cDomain.getMinBound() + "\" max=\"" + cDomain.getMaxBound() + "\" />");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public <E extends Serializable, F extends Serializable> void visit(Domain<E,F> domain,
            F label, E value) {

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void end(Domain domain) {
        xmlBuffer.append("</fixed>");
        xmlBuffer.append("</domain>");
    }
}
