/*
 * ##% Copyright (C) 2002 2009
 *     Ifremer, Code Lutin, Benjamin Poussin, Tony Chemit
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##% */
package fr.ifremer.isisfish.logging;

/**
 * abstraction of a log level   TODO put it in LutinLog
 * <p/>
 * a LogLevel is defined by 3 properties :
 * <ul>
 * <li> his name (given by {@link #name()}) </li>
 * <li> his severity <b>(higher severity is the lower value, be carefull)
 * </b> (given by {@link #ordinal()}) </li>
 * <li> his mask value (given by {@link #mask()}) </li>
 * </ul>
 * The mask value is introduced to make possible some performant search.
 * <p/>
 * Using the <b>"<code>1 << ordinal()</code>"</b> idiom is the easiest manner to manage
 * operations of set of LogLevels.
 * <p/>
 * To obtain a LogLevel from his severity, use {@link #getLogLevel(int)}
 *
 * @author chemit
 * @see LogLevelUtil
 * @see LogLevelUtil#createSet(int, int...)
 * @see LogLevelUtil#addToSet(int,int)
 * @see LogLevelUtil#removeFromSet(int,int)
 * @see LogLevelUtil#getLogLevels(int)
 */
public enum LogLevel {
    FATAL, // severity 0 : the highest severity
    ERROR, // severity 1 : ...
    WARN,
    INFO,
    DEBUG,
    TRACE,
    USER; // the lowest severity

    /** the array of all levels ordering by severity (higher to lower) */
    static final LogLevel[] ALL_LEVELS = values();

    /** the highest log level */
    static final int MAX_LOG_LEVEL = ALL_LEVELS.length;

    /** search version of the level. */
    private final int mask;

    LogLevel() {
        mask = 1 << ordinal();
    }

    public int mask() {
        return mask;
    }

    /**
     * @param ordinal the ordinal of of the level
     * @return the LogLevel if found, or null.
     */
    public static LogLevel getLogLevel(int ordinal) {
        LogLevel result = null;
        if (ordinal > -1 && ordinal <= MAX_LOG_LEVEL) {
            result = ALL_LEVELS[ordinal];
        }
        return result;
    }
}
