/* *##%
 * Copyright (C) 2006 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.export;

import java.io.Writer;

import fr.ifremer.isisfish.datastore.SimulationStorage;

/**
 * Interface que doivent implanter les classes d'export de resultats.
 * 
 * Le nom du fichier d'export qui sera utilisé sera le basé sur le nom de la
 * classe d'export
 * 
 * Created: 22 janv. 2006 21:12:58
 *
 * @author poussin
 * @version $Revision: 2575 $
 *
 * Last update: $Date: 2009-09-02 15:47:17 +0200 (mer., 02 sept. 2009) $
 * by : $Author: chatellier $
 */
public interface Export {

    /**
     * Necessary results names for export execution.
     * 
     * @return the necessaryResult name
     */
    public String[] getNecessaryResult();

    /**
     * Return Export description.
     * 
     * @return string displayable to the end user
     */
    public String getDescription();

    /**
     * Return filename used to contains export data.
     * 
     * @return filename by example "myexport"
     */
    public String getExportFilename();

    /**
     * Return extension used as filename name extension.
     * 
     * @return extension by example ".csv"
     */
    public String getExtensionFilename();

    /**
     * Exporte les resultat.
     * 
     * @param simulation la simulation dont on souhaite exporter les resultats
     * @param out la sortie sur lequel il faut ecrire l'export
     * @throws Exception if export fail
     */
    public void export(SimulationStorage simulation, Writer out)
            throws Exception;

}
