/*
 *  Copyright (C) 2002-2009 Ifremer, Code Lutin, Benjamin Poussin
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;

/**
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public interface SoVTechnicalEfficiencyEquation {
    
    /**
     * @param context
     * @param metier le metier pour lequel on demande le calcul
     * @param gear l'engin utilise par le metier
     * @return equation result
     */
    @Args({"context", "metier", "gear"})
    public double compute(SimulationContext context, Metier metier, Gear gear) throws Exception;

}
