/* *##%
 * Copyright (C) 2006 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;

/**
 * PopulationMeanWeight equation.
 *
 * Created: 23 août 2006 11:14:46
 *
 * @author poussin
 * @version $Revision: 2805 $
 *
 * Last update: $Date: 2009-12-07 16:46:49 +0100 (lun., 07 déc. 2009) $
 * by : $Author: chatellier $
 */
public interface PopulationMeanWeight {

    /**
     * Compute population mean weight.
     * 
     * @param context simulation context
     * @param group le groupe dont on souhaite le poids moyen
     * @return population mean weight
     * @throws Exception
     */
    @Args({"context", "group"})
    public double compute(SimulationContext context, PopulationGroup group) throws Exception;

}


