/* *##%
 * Copyright (C) 2006 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

/* *
 * PopulationGrowth.java
 *
 * Created: 4 juil. 2006 13:03:25
 *
 * @author poussin
 * @version $Revision: 2556 $
 *
 * Last update: $Date: 2009-08-27 18:05:07 +0200 (jeu., 27 août 2009) $
 * by : $Author: chatellier $
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;


/**
 * @author poussin
 *
 */

public interface PopulationGrowth {
    
    /**
     * 
     * @param context
     * @param age l'age du groupe en mois
     * @param group le groupe dont on souhaite avoir la longueur en fonction de l'age
     * @return equation result
     */
    @Args({"context", "age", "group"})
    public double compute(SimulationContext context, double age, PopulationGroup group) throws Exception;

}


