/* *##%
 * Copyright (C) 2006 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

/* *
 * ImmigrationEquation.java
 *
 * Created: 23 août 2006 12:06:32
 *
 * @author poussin
 * @version $Revision: 2658 $
 *
 * Last update: $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
 * by : $Author: chatellier $
 */

package fr.ifremer.isisfish.equation;

import org.nuiton.math.matrix.MatrixND;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;


/**
 * @author poussin
 *
 */

public interface ImmigrationEquation {
    
    /**
     * 
     * @param context
     * @param N effectif de la population
     * @param pop la population pour lequel on souhaite le nombre d'immigration
     * @param group le group pour lequel on souhaite le nombre d'immigration
     * @param arrivalZone la zone d'arrivé de l'immigration
     * @return le nombre d'individu a immigrer dans la zone
     * d'arrivé pour le groupe passé en argument
     */
   @Args({"context", "N", "pop", "group", "arrivalZone"})
    public double compute(SimulationContext context,
            MatrixND N, Population pop, PopulationGroup group,
            Zone arrivalZone) throws Exception;

}


