/* *##%
 * Copyright (C) 2006 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageException;

/**
 * Implantation des operations pour l'entité Zone.
 * 
 * Created: 23 août 2006 16:38:23
 *
 * @author poussin
 * @version $Revision: 2081 $
 *
 * Last update: $Date: 2009-04-07 15:14:40 +0200 (mar., 07 avril 2009) $
 * by : $Author: chatellier $
 */
public class ZoneImpl extends ZoneAbstract {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    public FisheryRegion getFisheryRegion() {
        try {
            FisheryRegion result = RegionStorage
                    .getFisheryRegion(getTopiaContext());
            return result;
        } catch (StorageException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    /* (non-Javadoc)
     * @see fr.ifremer.isisfish.entities.FisheryRegionAbstract#toString()
     */
    @Override
    public String toString() {
        String result = getName();
        return result;
    }

} //ZoneImpl
