package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class ZoneDAOAbstract<E extends Zone> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Zone.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<fr.ifremer.isisfish.entities.MetierSeasonInfo> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from metierSeasonInfo main, metierseasoninfo_zone secondary " +
                    "where main.topiaid=secondary.metierSeasonInfo" +
                    " and secondary.zone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(fr.ifremer.isisfish.entities.MetierSeasonInfo.class)).list();
            for (fr.ifremer.isisfish.entities.MetierSeasonInfo item : list) {
                item.removeZone(entity);
            }
        }

        {
            List<fr.ifremer.isisfish.entities.Population> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from population main, population_reproductionzone secondary " +
                    "where main.topiaid=secondary.population" +
                    " and secondary.reproductionZone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(fr.ifremer.isisfish.entities.Population.class)).list();
            for (fr.ifremer.isisfish.entities.Population item : list) {
                item.removeReproductionZone(entity);
            }
        }

        {
            List<fr.ifremer.isisfish.entities.Population> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from population main, population_populationzone secondary " +
                    "where main.topiaid=secondary.population" +
                    " and secondary.populationZone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(fr.ifremer.isisfish.entities.Population.class)).list();
            for (fr.ifremer.isisfish.entities.Population item : list) {
                item.removePopulationZone(entity);
            }
        }

        {
            List<fr.ifremer.isisfish.entities.Population> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from population main, population_recruitmentzone secondary " +
                    "where main.topiaid=secondary.population" +
                    " and secondary.recruitmentZone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(fr.ifremer.isisfish.entities.Population.class)).list();
            for (fr.ifremer.isisfish.entities.Population item : list) {
                item.removeRecruitmentZone(entity);
            }
        }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findContainsCell :
     * Retourne le premier élément trouvé dont l'attribut cell contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsCell(Cell... v) throws TopiaException {
        E result = findContainsProperties("cell", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsCell :
     * Retourne les éléments trouvé dont l'attribut cell contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsCell(Cell... v) throws TopiaException {
        List<E> results = findAllContainsProperties("cell", Arrays.asList(v));
        return results;
    }


} //ZoneDAOAbstract<E extends Zone>
