package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class ZoneAbstract extends TopiaEntityAbstract implements Zone {

    private String name;
    private String comment;
    public List<Cell> cell;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Zone.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Zone.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "cell", List.class, Cell.class, cell);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * addCell :
     * @param cell 
     */

    public void addCell(Cell cell) {    
        fireOnPreWrite("cell", null, cell);
        if (this.cell == null) {
            this.cell = new ArrayList<Cell>();
        }
        this.cell.add(cell);
        fireOnPostWrite("cell", this.cell.size(), null, cell);
}

    /**
     * addAllCell :
     * @param values 
     */

    public void addAllCell(List<Cell> values) {
        if (values == null) {
            return;
        }
        for (Cell item : values) {
            addCell(item);
        }
}

    /**
     * getCellByTopiaId :
     * @param topiaId 
     * @return Cell 
     */

    public Cell getCellByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(cell, topiaId);
 }

    /**
     * setCell :
     * @param values 
     */

    public void setCell(List<Cell> values) {
        List<Cell> _oldValue = cell;
        fireOnPreWrite("cell", _oldValue, values);
        cell = values;
        fireOnPostWrite("cell", _oldValue, values);
}

    /**
     * removeCell :
     * @param value 
     */

    public void removeCell(Cell value) {
        fireOnPreWrite("cell", value, null);
        if ((this.cell == null) || (!this.cell.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("cell", this.cell.size()+1, value, null);
}

    /**
     * clearCell :
     */

    public void clearCell() {
        if (this.cell == null) {
            return;
        }
        List<Cell> _oldValue = new ArrayList<Cell>(this.cell);
        fireOnPreWrite("cell", _oldValue, this.cell);
        this.cell.clear();
        fireOnPostWrite("cell", _oldValue, this.cell);
}

    /**
     * getCell :
     * @return List<Cell> 
     */

    public List<Cell> getCell() {
        return cell;
}

    /**
     * sizeCell :
     * @return int 
     */

    public int sizeCell() {
        if (cell == null) {
            return 0;
        }
        return cell.size();
}

    /**
     * isCellEmpty :
     * @return boolean 
     */

    public boolean isCellEmpty() {
        int size = sizeCell();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("comment", this.comment).
            append("cell", this.cell).
         toString();
        return result;
}


} //ZoneAbstract
