package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class VesselTypeDAOAbstract<E extends VesselType> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)VesselType.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<fr.ifremer.isisfish.entities.SetOfVessels> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.SetOfVessels.class)
                            .findAllByProperties("vesselType", entity);
                    for (fr.ifremer.isisfish.entities.SetOfVessels item : list) {
                        item.setVesselType(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByLength :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut length le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLength(int v) throws TopiaException {
        E result = findByProperty("length", v);
        return result;
    }

    /**
     * findAllByLength :
     * Retourne les éléments ayant comme valeur pour l'attribut length le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLength(int v) throws TopiaException {
        List<E> result = findAllByProperty("length", v);
        return result;
    }

    /**
     * findBySpeed :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut speed le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySpeed(double v) throws TopiaException {
        E result = findByProperty("speed", v);
        return result;
    }

    /**
     * findAllBySpeed :
     * Retourne les éléments ayant comme valeur pour l'attribut speed le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySpeed(double v) throws TopiaException {
        List<E> result = findAllByProperty("speed", v);
        return result;
    }

    /**
     * findByMaxTripDuration :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maxTripDuration le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaxTripDuration(TimeUnit v) throws TopiaException {
        E result = findByProperty("maxTripDuration", v);
        return result;
    }

    /**
     * findAllByMaxTripDuration :
     * Retourne les éléments ayant comme valeur pour l'attribut maxTripDuration le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaxTripDuration(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty("maxTripDuration", v);
        return result;
    }

    /**
     * findByActivityRange :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut activityRange le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByActivityRange(double v) throws TopiaException {
        E result = findByProperty("activityRange", v);
        return result;
    }

    /**
     * findAllByActivityRange :
     * Retourne les éléments ayant comme valeur pour l'attribut activityRange le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByActivityRange(double v) throws TopiaException {
        List<E> result = findAllByProperty("activityRange", v);
        return result;
    }

    /**
     * findByMinCrewSize :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minCrewSize le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinCrewSize(int v) throws TopiaException {
        E result = findByProperty("minCrewSize", v);
        return result;
    }

    /**
     * findAllByMinCrewSize :
     * Retourne les éléments ayant comme valeur pour l'attribut minCrewSize le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinCrewSize(int v) throws TopiaException {
        List<E> result = findAllByProperty("minCrewSize", v);
        return result;
    }

    /**
     * findByUnitFuelCostOfTravel :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut unitFuelCostOfTravel le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByUnitFuelCostOfTravel(double v) throws TopiaException {
        E result = findByProperty("unitFuelCostOfTravel", v);
        return result;
    }

    /**
     * findAllByUnitFuelCostOfTravel :
     * Retourne les éléments ayant comme valeur pour l'attribut unitFuelCostOfTravel le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByUnitFuelCostOfTravel(double v) throws TopiaException {
        List<E> result = findAllByProperty("unitFuelCostOfTravel", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findContainsTripType :
     * Retourne le premier élément trouvé dont l'attribut tripType contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsTripType(TripType... v) throws TopiaException {
        E result = findContainsProperties("tripType", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsTripType :
     * Retourne les éléments trouvé dont l'attribut tripType contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsTripType(TripType... v) throws TopiaException {
        List<E> results = findAllContainsProperties("tripType", Arrays.asList(v));
        return results;
    }


} //VesselTypeDAOAbstract<E extends VesselType>
