package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class VesselTypeAbstract extends TopiaEntityAbstract implements VesselType {

    private String name;
    private int length;
    private double speed;
    private TimeUnit maxTripDuration;
    private double activityRange;
    /**
     * <p>Taille minimum de l'&eacute;quipage sur ce style de bateau</p>


     */
    private int minCrewSize;
    /**
     * <p>Co&ucirc;t d'un heure de carburant</p>


     */
    private double unitFuelCostOfTravel;
    private String comment;
    public Collection<TripType> tripType;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VesselType.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VesselType.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "length", int.class, length);
        visitor.visit(this, "speed", double.class, speed);
        visitor.visit(this, "maxTripDuration", TimeUnit.class, maxTripDuration);
        visitor.visit(this, "activityRange", double.class, activityRange);
        visitor.visit(this, "minCrewSize", int.class, minCrewSize);
        visitor.visit(this, "unitFuelCostOfTravel", double.class, unitFuelCostOfTravel);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "tripType", Collection.class, TripType.class, tripType);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setLength :
     * @param value 
     */

    public void setLength(int value) {
        int _oldValue = this.length;
        fireOnPreWrite("length", _oldValue, value);
        this.length = value;
        fireOnPostWrite("length", _oldValue, value);
}

    /**
     * getLength :
     * @return int 
     */

    public int getLength() {
        fireOnPreRead("length", length);
        int result = this.length;
        fireOnPostRead("length", length);
        return result;
}

    /**
     * setSpeed :
     * @param value 
     */

    public void setSpeed(double value) {
        double _oldValue = this.speed;
        fireOnPreWrite("speed", _oldValue, value);
        this.speed = value;
        fireOnPostWrite("speed", _oldValue, value);
}

    /**
     * getSpeed :
     * @return double 
     */

    public double getSpeed() {
        fireOnPreRead("speed", speed);
        double result = this.speed;
        fireOnPostRead("speed", speed);
        return result;
}

    /**
     * setMaxTripDuration :
     * @param value 
     */

    public void setMaxTripDuration(TimeUnit value) {
        TimeUnit _oldValue = this.maxTripDuration;
        fireOnPreWrite("maxTripDuration", _oldValue, value);
        this.maxTripDuration = value;
        fireOnPostWrite("maxTripDuration", _oldValue, value);
}

    /**
     * getMaxTripDuration :
     * @return TimeUnit 
     */

    public TimeUnit getMaxTripDuration() {
        fireOnPreRead("maxTripDuration", maxTripDuration);
        TimeUnit result = this.maxTripDuration;
        fireOnPostRead("maxTripDuration", maxTripDuration);
        return result;
}

    /**
     * setActivityRange :
     * @param value 
     */

    public void setActivityRange(double value) {
        double _oldValue = this.activityRange;
        fireOnPreWrite("activityRange", _oldValue, value);
        this.activityRange = value;
        fireOnPostWrite("activityRange", _oldValue, value);
}

    /**
     * getActivityRange :
     * @return double 
     */

    public double getActivityRange() {
        fireOnPreRead("activityRange", activityRange);
        double result = this.activityRange;
        fireOnPostRead("activityRange", activityRange);
        return result;
}

    /**
     * setMinCrewSize :
     * @param value 
     */

    public void setMinCrewSize(int value) {
        int _oldValue = this.minCrewSize;
        fireOnPreWrite("minCrewSize", _oldValue, value);
        this.minCrewSize = value;
        fireOnPostWrite("minCrewSize", _oldValue, value);
}

    /**
     * getMinCrewSize :
     * @return int 
     */

    public int getMinCrewSize() {
        fireOnPreRead("minCrewSize", minCrewSize);
        int result = this.minCrewSize;
        fireOnPostRead("minCrewSize", minCrewSize);
        return result;
}

    /**
     * setUnitFuelCostOfTravel :
     * @param value 
     */

    public void setUnitFuelCostOfTravel(double value) {
        double _oldValue = this.unitFuelCostOfTravel;
        fireOnPreWrite("unitFuelCostOfTravel", _oldValue, value);
        this.unitFuelCostOfTravel = value;
        fireOnPostWrite("unitFuelCostOfTravel", _oldValue, value);
}

    /**
     * getUnitFuelCostOfTravel :
     * @return double 
     */

    public double getUnitFuelCostOfTravel() {
        fireOnPreRead("unitFuelCostOfTravel", unitFuelCostOfTravel);
        double result = this.unitFuelCostOfTravel;
        fireOnPostRead("unitFuelCostOfTravel", unitFuelCostOfTravel);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * addTripType :
     * @param tripType 
     */

    public void addTripType(TripType tripType) {    
        fireOnPreWrite("tripType", null, tripType);
        if (this.tripType == null) {
            this.tripType = new ArrayList<TripType>();
        }
        this.tripType.add(tripType);
        fireOnPostWrite("tripType", this.tripType.size(), null, tripType);
}

    /**
     * addAllTripType :
     * @param values 
     */

    public void addAllTripType(Collection<TripType> values) {
        if (values == null) {
            return;
        }
        for (TripType item : values) {
            addTripType(item);
        }
}

    /**
     * getTripTypeByTopiaId :
     * @param topiaId 
     * @return TripType 
     */

    public TripType getTripTypeByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(tripType, topiaId);
 }

    /**
     * setTripType :
     * @param values 
     */

    public void setTripType(Collection<TripType> values) {
        Collection<TripType> _oldValue = tripType;
        fireOnPreWrite("tripType", _oldValue, values);
        tripType = values;
        fireOnPostWrite("tripType", _oldValue, values);
}

    /**
     * removeTripType :
     * @param value 
     */

    public void removeTripType(TripType value) {
        fireOnPreWrite("tripType", value, null);
        if ((this.tripType == null) || (!this.tripType.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("tripType", this.tripType.size()+1, value, null);
}

    /**
     * clearTripType :
     */

    public void clearTripType() {
        if (this.tripType == null) {
            return;
        }
        Collection<TripType> _oldValue = new ArrayList<TripType>(this.tripType);
        fireOnPreWrite("tripType", _oldValue, this.tripType);
        this.tripType.clear();
        fireOnPostWrite("tripType", _oldValue, this.tripType);
}

    /**
     * getTripType :
     * @return Collection<TripType> 
     */

    public Collection<TripType> getTripType() {
        return tripType;
}

    /**
     * sizeTripType :
     * @return int 
     */

    public int sizeTripType() {
        if (tripType == null) {
            return 0;
        }
        return tripType.size();
}

    /**
     * isTripTypeEmpty :
     * @return boolean 
     */

    public boolean isTripTypeEmpty() {
        int size = sizeTripType();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("length", this.length).
            append("speed", this.speed).
            append("maxTripDuration", this.maxTripDuration).
            append("activityRange", this.activityRange).
            append("minCrewSize", this.minCrewSize).
            append("unitFuelCostOfTravel", this.unitFuelCostOfTravel).
            append("comment", this.comment).
            append("tripType", this.tripType).
         toString();
        return result;
}


} //VesselTypeAbstract
