package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.Collection;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"name","comment"},
  numFields={"length","speed","activityRange","minCrewSize","unitFuelCostOfTravel"}
)

public interface VesselType extends TopiaEntity {     String NAME = "name";
     String LENGTH = "length";
     String SPEED = "speed";
     String MAX_TRIP_DURATION = "maxTripDuration";
     String ACTIVITY_RANGE = "activityRange";
     String MIN_CREW_SIZE = "minCrewSize";
     String UNIT_FUEL_COST_OF_TRAVEL = "unitFuelCostOfTravel";
     String COMMENT = "comment";
     String TRIP_TYPE = "tripType";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setLength :
     * @param length La valeur de l'attribut length à positionner.
     */

     void setLength(int length);

    /**
     * getLength :
     * @return int 
     */

     int getLength();

    /**
     * setSpeed :
     * @param speed La valeur de l'attribut speed à positionner.
     */

     void setSpeed(double speed);

    /**
     * getSpeed :
     * @return double 
     */

     double getSpeed();

    /**
     * setMaxTripDuration :
     * @param maxTripDuration La valeur de l'attribut maxTripDuration à positionner.
     */

     void setMaxTripDuration(TimeUnit maxTripDuration);

    /**
     * getMaxTripDuration :
     * @return TimeUnit 
     */

     TimeUnit getMaxTripDuration();

    /**
     * setActivityRange :
     * @param activityRange La valeur de l'attribut activityRange à positionner.
     */

     void setActivityRange(double activityRange);

    /**
     * getActivityRange :
     * @return double 
     */

     double getActivityRange();

    /**
     * setMinCrewSize :
     * <p>Taille minimum de l'&eacute;quipage sur ce style de bateau</p>

     * @param minCrewSize La valeur de l'attribut minCrewSize à positionner.
     */

     void setMinCrewSize(int minCrewSize);

    /**
     * getMinCrewSize :
     * <p>Taille minimum de l'&eacute;quipage sur ce style de bateau</p>

     * @return int 
     */

     int getMinCrewSize();

    /**
     * setUnitFuelCostOfTravel :
     * <p>Co&ucirc;t d'un heure de carburant</p>

     * @param unitFuelCostOfTravel La valeur de l'attribut unitFuelCostOfTravel à positionner.
     */

     void setUnitFuelCostOfTravel(double unitFuelCostOfTravel);

    /**
     * getUnitFuelCostOfTravel :
     * <p>Co&ucirc;t d'un heure de carburant</p>

     * @return double 
     */

     double getUnitFuelCostOfTravel();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * addTripType :
     * @param tripType L'instance de tripType à ajouter
     */

     void addTripType(TripType tripType);

    /**
     * addAllTripType :
     * @param tripType Les instances de tripType à ajouter
     */

     void addAllTripType(Collection<TripType> tripType);

    /**
     * setTripType :
     * @param tripType La Collection de tripType à ajouter
     */

     void setTripType(Collection<TripType> tripType);

    /**
     * removeTripType :
     * @param tripType Vide la Collection de tripType
     */

     void removeTripType(TripType tripType);

    /**
     * clearTripType :
     */

     void clearTripType();

    /**
     * getTripType :
     * @return Collection<TripType> 
     */

     Collection<TripType> getTripType();

    /**
     * getTripTypeByTopiaId :
     * Recupère l'attribut tripType à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TripType 
     */

     TripType getTripTypeByTopiaId(String topiaId);

    /**
     * sizeTripType :
     * Retourne le nombre d'éléments de la collection tripType
     * @return int 
     */

     int sizeTripType();

    /**
     * isTripTypeEmpty :
     * Retourne {@code true} si la collection tripType est vide.
     * @return boolean 
     */

     boolean isTripTypeEmpty();

    /**
     * getFisheryRegion :
     * @return FisheryRegion 
     */

     FisheryRegion getFisheryRegion();


} //VesselType
