package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class TripTypeDAOAbstract<E extends TripType> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TripType.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<fr.ifremer.isisfish.entities.VesselType> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from vesselType main, triptype_vesseltype secondary " +
                    "where main.topiaid=secondary.vesselType" +
                    " and secondary.tripType='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(fr.ifremer.isisfish.entities.VesselType.class)).list();
            for (fr.ifremer.isisfish.entities.VesselType item : list) {
                item.removeTripType(entity);
            }
        }

                {
                List<fr.ifremer.isisfish.entities.StrategyMonthInfo> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.StrategyMonthInfo.class)
                            .findAllByProperties("tripType", entity);
                    for (fr.ifremer.isisfish.entities.StrategyMonthInfo item : list) {
                        item.setTripType(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByTripDuration :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut tripDuration le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTripDuration(TimeUnit v) throws TopiaException {
        E result = findByProperty("tripDuration", v);
        return result;
    }

    /**
     * findAllByTripDuration :
     * Retourne les éléments ayant comme valeur pour l'attribut tripDuration le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTripDuration(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty("tripDuration", v);
        return result;
    }

    /**
     * findByMinTimeBetweenTrip :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minTimeBetweenTrip le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinTimeBetweenTrip(TimeUnit v) throws TopiaException {
        E result = findByProperty("minTimeBetweenTrip", v);
        return result;
    }

    /**
     * findAllByMinTimeBetweenTrip :
     * Retourne les éléments ayant comme valeur pour l'attribut minTimeBetweenTrip le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinTimeBetweenTrip(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty("minTimeBetweenTrip", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }


} //TripTypeDAOAbstract<E extends TripType>
