package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class TripTypeAbstract extends TopiaEntityAbstract implements TripType {

    private String name;
    private TimeUnit tripDuration;
    private TimeUnit minTimeBetweenTrip;
    private String comment;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TripType.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TripType.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "tripDuration", TimeUnit.class, tripDuration);
        visitor.visit(this, "minTimeBetweenTrip", TimeUnit.class, minTimeBetweenTrip);
        visitor.visit(this, "comment", String.class, comment);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setTripDuration :
     * @param value 
     */

    public void setTripDuration(TimeUnit value) {
        TimeUnit _oldValue = this.tripDuration;
        fireOnPreWrite("tripDuration", _oldValue, value);
        this.tripDuration = value;
        fireOnPostWrite("tripDuration", _oldValue, value);
}

    /**
     * getTripDuration :
     * @return TimeUnit 
     */

    public TimeUnit getTripDuration() {
        fireOnPreRead("tripDuration", tripDuration);
        TimeUnit result = this.tripDuration;
        fireOnPostRead("tripDuration", tripDuration);
        return result;
}

    /**
     * setMinTimeBetweenTrip :
     * @param value 
     */

    public void setMinTimeBetweenTrip(TimeUnit value) {
        TimeUnit _oldValue = this.minTimeBetweenTrip;
        fireOnPreWrite("minTimeBetweenTrip", _oldValue, value);
        this.minTimeBetweenTrip = value;
        fireOnPostWrite("minTimeBetweenTrip", _oldValue, value);
}

    /**
     * getMinTimeBetweenTrip :
     * @return TimeUnit 
     */

    public TimeUnit getMinTimeBetweenTrip() {
        fireOnPreRead("minTimeBetweenTrip", minTimeBetweenTrip);
        TimeUnit result = this.minTimeBetweenTrip;
        fireOnPostRead("minTimeBetweenTrip", minTimeBetweenTrip);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("tripDuration", this.tripDuration).
            append("minTimeBetweenTrip", this.minTimeBetweenTrip).
            append("comment", this.comment).
         toString();
        return result;
}


} //TripTypeAbstract
