package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class TargetSpeciesDAOAbstract<E extends TargetSpecies> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TargetSpecies.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByTargetFactorEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut targetFactorEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTargetFactorEquation(Equation v) throws TopiaException {
        E result = findByProperty("targetFactorEquation", v);
        return result;
    }

    /**
     * findAllByTargetFactorEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut targetFactorEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTargetFactorEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("targetFactorEquation", v);
        return result;
    }

    /**
     * findByPrimaryCatch :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut primaryCatch le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPrimaryCatch(boolean v) throws TopiaException {
        E result = findByProperty("primaryCatch", v);
        return result;
    }

    /**
     * findAllByPrimaryCatch :
     * Retourne les éléments ayant comme valeur pour l'attribut primaryCatch le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPrimaryCatch(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("primaryCatch", v);
        return result;
    }

    /**
     * findContainsSpecies :
     * Retourne le premier élément trouvé dont l'attribut species contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsSpecies(Species... v) throws TopiaException {
        E result = findContainsProperties("species", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsSpecies :
     * Retourne les éléments trouvé dont l'attribut species contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsSpecies(Species... v) throws TopiaException {
        List<E> results = findAllContainsProperties("species", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsMetierSeasonInfo :
     * Retourne le premier élément trouvé dont l'attribut metierSeasonInfo contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsMetierSeasonInfo(MetierSeasonInfo... v) throws TopiaException {
        E result = findContainsProperties("metierSeasonInfo", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsMetierSeasonInfo :
     * Retourne les éléments trouvé dont l'attribut metierSeasonInfo contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsMetierSeasonInfo(MetierSeasonInfo... v) throws TopiaException {
        List<E> results = findAllContainsProperties("metierSeasonInfo", Arrays.asList(v));
        return results;
    }


} //TargetSpeciesDAOAbstract<E extends TargetSpecies>
