package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class TargetSpeciesAbstract extends TopiaEntityAbstract implements TargetSpecies {

    private Equation targetFactorEquation;
    /**
     * <p>Vrai si la MetaPopulation est une esp&egrave;ce vis&eacute;e prioritairement</p>


     */
    private boolean primaryCatch;
    public Species species;
    public MetierSeasonInfo metierSeasonInfo;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TargetSpecies.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TargetSpecies.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "targetFactorEquation", Equation.class, targetFactorEquation);
        visitor.visit(this, "primaryCatch", boolean.class, primaryCatch);
        visitor.visit(this, "species", Species.class, species);
        visitor.visit(this, "metierSeasonInfo", MetierSeasonInfo.class, metierSeasonInfo);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getTargetFactorEquation());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setTargetFactorEquation :
     * @param value 
     */

    public void setTargetFactorEquation(Equation value) {
        Equation _oldValue = this.targetFactorEquation;
        fireOnPreWrite("targetFactorEquation", _oldValue, value);
        this.targetFactorEquation = value;
        fireOnPostWrite("targetFactorEquation", _oldValue, value);
}

    /**
     * getTargetFactorEquation :
     * @return Equation 
     */

    public Equation getTargetFactorEquation() {
        fireOnPreRead("targetFactorEquation", targetFactorEquation);
        Equation result = this.targetFactorEquation;
        fireOnPostRead("targetFactorEquation", targetFactorEquation);
        return result;
}

    /**
     * setPrimaryCatch :
     * @param value 
     */

    public void setPrimaryCatch(boolean value) {
        boolean _oldValue = this.primaryCatch;
        fireOnPreWrite("primaryCatch", _oldValue, value);
        this.primaryCatch = value;
        fireOnPostWrite("primaryCatch", _oldValue, value);
}

    /**
     * getPrimaryCatch :
     * @return boolean 
     */

    public boolean getPrimaryCatch() {
        fireOnPreRead("primaryCatch", primaryCatch);
        boolean result = this.primaryCatch;
        fireOnPostRead("primaryCatch", primaryCatch);
        return result;
}

    /**
     * setSpecies :
     * @param value La valeur de l'attribut species à positionner.
     */

    public void setSpecies(Species value) {
        Species _oldValue = this.species;
        fireOnPreWrite("species", _oldValue, value);
        this.species = value;
        fireOnPostWrite("species", _oldValue, value);
}

    /**
     * getSpecies :
     * @return Species 
     */

    public Species getSpecies() {    
        return species;
}

    /**
     * setMetierSeasonInfo :
     * @param value La valeur de l'attribut metierSeasonInfo à positionner.
     */

    public void setMetierSeasonInfo(MetierSeasonInfo value) {
        MetierSeasonInfo _oldValue = this.metierSeasonInfo;
        fireOnPreWrite("metierSeasonInfo", _oldValue, value);
        this.metierSeasonInfo = value;
        fireOnPostWrite("metierSeasonInfo", _oldValue, value);
}

    /**
     * getMetierSeasonInfo :
     * @return MetierSeasonInfo 
     */

    public MetierSeasonInfo getMetierSeasonInfo() {    
        return metierSeasonInfo;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("targetFactorEquation", this.targetFactorEquation).
            append("primaryCatch", this.primaryCatch).
         toString();
        return result;
}


} //TargetSpeciesAbstract
