package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.Arrays;
import java.util.List;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class StrategyMonthInfoDAOAbstract<E extends StrategyMonthInfo> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)StrategyMonthInfo.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByMonth :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut month le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMonth(Month v) throws TopiaException {
        E result = findByProperty("month", v);
        return result;
    }

    /**
     * findAllByMonth :
     * Retourne les éléments ayant comme valeur pour l'attribut month le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMonth(Month v) throws TopiaException {
        List<E> result = findAllByProperty("month", v);
        return result;
    }

    /**
     * findByMinInactivityDays :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minInactivityDays le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinInactivityDays(double v) throws TopiaException {
        E result = findByProperty("minInactivityDays", v);
        return result;
    }

    /**
     * findAllByMinInactivityDays :
     * Retourne les éléments ayant comme valeur pour l'attribut minInactivityDays le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinInactivityDays(double v) throws TopiaException {
        List<E> result = findAllByProperty("minInactivityDays", v);
        return result;
    }

    /**
     * findByNumberOfTrips :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut numberOfTrips le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByNumberOfTrips(double v) throws TopiaException {
        E result = findByProperty("numberOfTrips", v);
        return result;
    }

    /**
     * findAllByNumberOfTrips :
     * Retourne les éléments ayant comme valeur pour l'attribut numberOfTrips le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByNumberOfTrips(double v) throws TopiaException {
        List<E> result = findAllByProperty("numberOfTrips", v);
        return result;
    }

    /**
     * findByProportionMetier :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut proportionMetier le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByProportionMetier(MatrixND v) throws TopiaException {
        E result = findByProperty("proportionMetier", v);
        return result;
    }

    /**
     * findAllByProportionMetier :
     * Retourne les éléments ayant comme valeur pour l'attribut proportionMetier le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByProportionMetier(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("proportionMetier", v);
        return result;
    }

    /**
     * findByTripType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut tripType le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTripType(TripType v) throws TopiaException {
        E result = findByProperty("tripType", v);
        return result;
    }

    /**
     * findAllByTripType :
     * Retourne les éléments ayant comme valeur pour l'attribut tripType le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTripType(TripType v) throws TopiaException {
        List<E> result = findAllByProperty("tripType", v);
        return result;
    }

    /**
     * findByStrategy :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut strategy le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByStrategy(Strategy v) throws TopiaException {
        E result = findByProperty("strategy", v);
        return result;
    }

    /**
     * findAllByStrategy :
     * Retourne les éléments ayant comme valeur pour l'attribut strategy le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByStrategy(Strategy v) throws TopiaException {
        List<E> result = findAllByProperty("strategy", v);
        return result;
    }


} //StrategyMonthInfoDAOAbstract<E extends StrategyMonthInfo>
