package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class StrategyMonthInfoAbstract extends TopiaEntityAbstract implements StrategyMonthInfo {

    private Month month;
    private double minInactivityDays;
    /**
     * <p>Nombre de Trip par mois. Le nombre de jour d'inactivite et le nombre la duree d'un trip doivent &ecirc;tre coh&eacute;rent pour le mois</p>


     */
    private double numberOfTrips;
    private MatrixND proportionMetier;
    public TripType tripType;
    public Strategy strategy;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(StrategyMonthInfo.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(StrategyMonthInfo.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "month", Month.class, month);
        visitor.visit(this, "minInactivityDays", double.class, minInactivityDays);
        visitor.visit(this, "numberOfTrips", double.class, numberOfTrips);
        visitor.visit(this, "proportionMetier", MatrixND.class, proportionMetier);
        visitor.visit(this, "tripType", TripType.class, tripType);
        visitor.visit(this, "strategy", Strategy.class, strategy);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setMonth :
     * @param value 
     */

    public void setMonth(Month value) {
        Month _oldValue = this.month;
        fireOnPreWrite("month", _oldValue, value);
        this.month = value;
        fireOnPostWrite("month", _oldValue, value);
}

    /**
     * getMonth :
     * @return Month 
     */

    public Month getMonth() {
        fireOnPreRead("month", month);
        Month result = this.month;
        fireOnPostRead("month", month);
        return result;
}

    /**
     * setMinInactivityDays :
     * @param value 
     */

    public void setMinInactivityDays(double value) {
        double _oldValue = this.minInactivityDays;
        fireOnPreWrite("minInactivityDays", _oldValue, value);
        this.minInactivityDays = value;
        fireOnPostWrite("minInactivityDays", _oldValue, value);
}

    /**
     * getMinInactivityDays :
     * @return double 
     */

    public double getMinInactivityDays() {
        fireOnPreRead("minInactivityDays", minInactivityDays);
        double result = this.minInactivityDays;
        fireOnPostRead("minInactivityDays", minInactivityDays);
        return result;
}

    /**
     * setNumberOfTrips :
     * @param value 
     */

    public void setNumberOfTrips(double value) {
        double _oldValue = this.numberOfTrips;
        fireOnPreWrite("numberOfTrips", _oldValue, value);
        this.numberOfTrips = value;
        fireOnPostWrite("numberOfTrips", _oldValue, value);
}

    /**
     * getNumberOfTrips :
     * @return double 
     */

    public double getNumberOfTrips() {
        fireOnPreRead("numberOfTrips", numberOfTrips);
        double result = this.numberOfTrips;
        fireOnPostRead("numberOfTrips", numberOfTrips);
        return result;
}

    /**
     * setProportionMetier :
     * @param value 
     */

    public void setProportionMetier(MatrixND value) {
        MatrixND _oldValue = this.proportionMetier;
        fireOnPreWrite("proportionMetier", _oldValue, value);
        this.proportionMetier = value;
        fireOnPostWrite("proportionMetier", _oldValue, value);
}

    /**
     * getProportionMetier :
     * @return MatrixND 
     */

    public MatrixND getProportionMetier() {
        fireOnPreRead("proportionMetier", proportionMetier);
        MatrixND result = this.proportionMetier;
        fireOnPostRead("proportionMetier", proportionMetier);
        return result;
}

    /**
     * setTripType :
     * @param value 
     */

    public void setTripType(TripType value) {
        TripType _oldValue = this.tripType;
        fireOnPreWrite("tripType", _oldValue, value);
        this.tripType = value;
        fireOnPostWrite("tripType", _oldValue, value);
}

    /**
     * getTripType :
     * @return TripType 
     */

    public TripType getTripType() {
        fireOnPreRead("tripType", tripType);
        TripType result = this.tripType;
        fireOnPostRead("tripType", tripType);
        return result;
}

    /**
     * setStrategy :
     * @param value 
     */

    public void setStrategy(Strategy value) {
        Strategy _oldValue = this.strategy;
        fireOnPreWrite("strategy", _oldValue, value);
        this.strategy = value;
        fireOnPostWrite("strategy", _oldValue, value);
}

    /**
     * getStrategy :
     * @return Strategy 
     */

    public Strategy getStrategy() {
        fireOnPreRead("strategy", strategy);
        Strategy result = this.strategy;
        fireOnPostRead("strategy", strategy);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("month", this.month).
            append("minInactivityDays", this.minInactivityDays).
            append("numberOfTrips", this.numberOfTrips).
            append("proportionMetier", this.proportionMetier).
            append("tripType", this.tripType).
         toString();
        return result;
}


} //StrategyMonthInfoAbstract
