package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class StrategyDAOAbstract<E extends Strategy> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Strategy.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<fr.ifremer.isisfish.entities.StrategyMonthInfo> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.StrategyMonthInfo.class)
                            .findAllByProperties("strategy", entity);
                    for (fr.ifremer.isisfish.entities.StrategyMonthInfo item : list) {
                        item.setStrategy(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByProportionSetOfVessels :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut proportionSetOfVessels le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByProportionSetOfVessels(double v) throws TopiaException {
        E result = findByProperty("proportionSetOfVessels", v);
        return result;
    }

    /**
     * findAllByProportionSetOfVessels :
     * Retourne les éléments ayant comme valeur pour l'attribut proportionSetOfVessels le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByProportionSetOfVessels(double v) throws TopiaException {
        List<E> result = findAllByProperty("proportionSetOfVessels", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findByInactivityEquationUsed :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut inactivityEquationUsed le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByInactivityEquationUsed(boolean v) throws TopiaException {
        E result = findByProperty("inactivityEquationUsed", v);
        return result;
    }

    /**
     * findAllByInactivityEquationUsed :
     * Retourne les éléments ayant comme valeur pour l'attribut inactivityEquationUsed le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByInactivityEquationUsed(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("inactivityEquationUsed", v);
        return result;
    }

    /**
     * findByInactivityEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut inactivityEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByInactivityEquation(Equation v) throws TopiaException {
        E result = findByProperty("inactivityEquation", v);
        return result;
    }

    /**
     * findAllByInactivityEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut inactivityEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByInactivityEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("inactivityEquation", v);
        return result;
    }

    /**
     * findBySetOfVessels :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut setOfVessels le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySetOfVessels(SetOfVessels v) throws TopiaException {
        E result = findByProperty("setOfVessels", v);
        return result;
    }

    /**
     * findAllBySetOfVessels :
     * Retourne les éléments ayant comme valeur pour l'attribut setOfVessels le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySetOfVessels(SetOfVessels v) throws TopiaException {
        List<E> result = findAllByProperty("setOfVessels", v);
        return result;
    }

    /**
     * findContainsStrategyMonthInfo :
     * Retourne le premier élément trouvé dont l'attribut strategyMonthInfo contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsStrategyMonthInfo(StrategyMonthInfo... v) throws TopiaException {
        E result = findContainsProperties("strategyMonthInfo", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsStrategyMonthInfo :
     * Retourne les éléments trouvé dont l'attribut strategyMonthInfo contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsStrategyMonthInfo(StrategyMonthInfo... v) throws TopiaException {
        List<E> results = findAllContainsProperties("strategyMonthInfo", Arrays.asList(v));
        return results;
    }


} //StrategyDAOAbstract<E extends Strategy>
