package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class StrategyAbstract extends TopiaEntityAbstract implements Strategy {

    private String name;
    private double proportionSetOfVessels;
    private String comment;
    public boolean inactivityEquationUsed;
    public Equation inactivityEquation;
    public SetOfVessels setOfVessels;
    public List<StrategyMonthInfo> strategyMonthInfo;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Strategy.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Strategy.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "proportionSetOfVessels", double.class, proportionSetOfVessels);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "inactivityEquationUsed", boolean.class, inactivityEquationUsed);
        visitor.visit(this, "inactivityEquation", Equation.class, inactivityEquation);
        visitor.visit(this, "setOfVessels", SetOfVessels.class, setOfVessels);
        visitor.visit(this, "strategyMonthInfo", List.class, StrategyMonthInfo.class, strategyMonthInfo);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getInactivityEquation());
        if (getStrategyMonthInfo() != null) {
              tmp.addAll(getStrategyMonthInfo());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setProportionSetOfVessels :
     * @param value 
     */

    public void setProportionSetOfVessels(double value) {
        double _oldValue = this.proportionSetOfVessels;
        fireOnPreWrite("proportionSetOfVessels", _oldValue, value);
        this.proportionSetOfVessels = value;
        fireOnPostWrite("proportionSetOfVessels", _oldValue, value);
}

    /**
     * getProportionSetOfVessels :
     * @return double 
     */

    public double getProportionSetOfVessels() {
        fireOnPreRead("proportionSetOfVessels", proportionSetOfVessels);
        double result = this.proportionSetOfVessels;
        fireOnPostRead("proportionSetOfVessels", proportionSetOfVessels);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * setInactivityEquationUsed :
     * @param value 
     */

    public void setInactivityEquationUsed(boolean value) {
        boolean _oldValue = this.inactivityEquationUsed;
        fireOnPreWrite("inactivityEquationUsed", _oldValue, value);
        this.inactivityEquationUsed = value;
        fireOnPostWrite("inactivityEquationUsed", _oldValue, value);
}

    /**
     * getInactivityEquationUsed :
     * @return boolean 
     */

    public boolean getInactivityEquationUsed() {
        fireOnPreRead("inactivityEquationUsed", inactivityEquationUsed);
        boolean result = this.inactivityEquationUsed;
        fireOnPostRead("inactivityEquationUsed", inactivityEquationUsed);
        return result;
}

    /**
     * setInactivityEquation :
     * @param value 
     */

    public void setInactivityEquation(Equation value) {
        Equation _oldValue = this.inactivityEquation;
        fireOnPreWrite("inactivityEquation", _oldValue, value);
        this.inactivityEquation = value;
        fireOnPostWrite("inactivityEquation", _oldValue, value);
}

    /**
     * getInactivityEquation :
     * @return Equation 
     */

    public Equation getInactivityEquation() {
        fireOnPreRead("inactivityEquation", inactivityEquation);
        Equation result = this.inactivityEquation;
        fireOnPostRead("inactivityEquation", inactivityEquation);
        return result;
}

    /**
     * setSetOfVessels :
     * @param value 
     */

    public void setSetOfVessels(SetOfVessels value) {
        SetOfVessels _oldValue = this.setOfVessels;
        fireOnPreWrite("setOfVessels", _oldValue, value);
        this.setOfVessels = value;
        fireOnPostWrite("setOfVessels", _oldValue, value);
}

    /**
     * getSetOfVessels :
     * @return SetOfVessels 
     */

    public SetOfVessels getSetOfVessels() {
        fireOnPreRead("setOfVessels", setOfVessels);
        SetOfVessels result = this.setOfVessels;
        fireOnPostRead("setOfVessels", setOfVessels);
        return result;
}

    /**
     * addStrategyMonthInfo :
     * @param strategyMonthInfo 
     */

    public void addStrategyMonthInfo(StrategyMonthInfo strategyMonthInfo) {    
        fireOnPreWrite("strategyMonthInfo", null, strategyMonthInfo);
        if (this.strategyMonthInfo == null) {
            this.strategyMonthInfo = new ArrayList<StrategyMonthInfo>();
        }
        strategyMonthInfo.setStrategy(this);
        this.strategyMonthInfo.add(strategyMonthInfo);
        fireOnPostWrite("strategyMonthInfo", this.strategyMonthInfo.size(), null, strategyMonthInfo);
}

    /**
     * addAllStrategyMonthInfo :
     * @param values 
     */

    public void addAllStrategyMonthInfo(List<StrategyMonthInfo> values) {
        if (values == null) {
            return;
        }
        for (StrategyMonthInfo item : values) {
            addStrategyMonthInfo(item);
        }
}

    /**
     * getStrategyMonthInfoByTopiaId :
     * @param topiaId 
     * @return StrategyMonthInfo 
     */

    public StrategyMonthInfo getStrategyMonthInfoByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(strategyMonthInfo, topiaId);
 }

    /**
     * setStrategyMonthInfo :
     * @param values 
     */

    public void setStrategyMonthInfo(List<StrategyMonthInfo> values) {
        List<StrategyMonthInfo> _oldValue = strategyMonthInfo;
        fireOnPreWrite("strategyMonthInfo", _oldValue, values);
        strategyMonthInfo = values;
        fireOnPostWrite("strategyMonthInfo", _oldValue, values);
}

    /**
     * removeStrategyMonthInfo :
     * @param value 
     */

    public void removeStrategyMonthInfo(StrategyMonthInfo value) {
        fireOnPreWrite("strategyMonthInfo", value, null);
        if ((this.strategyMonthInfo == null) || (!this.strategyMonthInfo.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setStrategy(null);
        fireOnPostWrite("strategyMonthInfo", this.strategyMonthInfo.size()+1, value, null);
}

    /**
     * clearStrategyMonthInfo :
     */

    public void clearStrategyMonthInfo() {
        if (this.strategyMonthInfo == null) {
            return;
        }
        for (StrategyMonthInfo item : this.strategyMonthInfo) {
            item.setStrategy(null);
        }
        List<StrategyMonthInfo> _oldValue = new ArrayList<StrategyMonthInfo>(this.strategyMonthInfo);
        fireOnPreWrite("strategyMonthInfo", _oldValue, this.strategyMonthInfo);
        this.strategyMonthInfo.clear();
        fireOnPostWrite("strategyMonthInfo", _oldValue, this.strategyMonthInfo);
}

    /**
     * getStrategyMonthInfo :
     * @return List<StrategyMonthInfo> 
     */

    public List<StrategyMonthInfo> getStrategyMonthInfo() {
        return strategyMonthInfo;
}

    /**
     * sizeStrategyMonthInfo :
     * @return int 
     */

    public int sizeStrategyMonthInfo() {
        if (strategyMonthInfo == null) {
            return 0;
        }
        return strategyMonthInfo.size();
}

    /**
     * isStrategyMonthInfoEmpty :
     * @return boolean 
     */

    public boolean isStrategyMonthInfoEmpty() {
        int size = sizeStrategyMonthInfo();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("proportionSetOfVessels", this.proportionSetOfVessels).
            append("comment", this.comment).
            append("inactivityEquationUsed", this.inactivityEquationUsed).
            append("inactivityEquation", this.inactivityEquation).
            append("setOfVessels", this.setOfVessels).
         toString();
        return result;
}


} //StrategyAbstract
