package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class SpeciesDAOAbstract<E extends Species> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Species.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<fr.ifremer.isisfish.entities.Population> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.Population.class)
                            .findAllByProperties("species", entity);
                    for (fr.ifremer.isisfish.entities.Population item : list) {
                        item.setSpecies(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByScientificName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut scientificName le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByScientificName(String v) throws TopiaException {
        E result = findByProperty("scientificName", v);
        return result;
    }

    /**
     * findAllByScientificName :
     * Retourne les éléments ayant comme valeur pour l'attribut scientificName le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByScientificName(String v) throws TopiaException {
        List<E> result = findAllByProperty("scientificName", v);
        return result;
    }

    /**
     * findByCodeRubbin :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut codeRubbin le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCodeRubbin(String v) throws TopiaException {
        E result = findByProperty("codeRubbin", v);
        return result;
    }

    /**
     * findAllByCodeRubbin :
     * Retourne les éléments ayant comme valeur pour l'attribut codeRubbin le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCodeRubbin(String v) throws TopiaException {
        List<E> result = findAllByProperty("codeRubbin", v);
        return result;
    }

    /**
     * findByCodeCEE :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut codeCEE le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCodeCEE(int v) throws TopiaException {
        E result = findByProperty("codeCEE", v);
        return result;
    }

    /**
     * findAllByCodeCEE :
     * Retourne les éléments ayant comme valeur pour l'attribut codeCEE le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCodeCEE(int v) throws TopiaException {
        List<E> result = findAllByProperty("codeCEE", v);
        return result;
    }

    /**
     * findByAgeGroupType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut ageGroupType le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAgeGroupType(boolean v) throws TopiaException {
        E result = findByProperty("ageGroupType", v);
        return result;
    }

    /**
     * findAllByAgeGroupType :
     * Retourne les éléments ayant comme valeur pour l'attribut ageGroupType le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAgeGroupType(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("ageGroupType", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findContainsPopulation :
     * Retourne le premier élément trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulation(Population... v) throws TopiaException {
        E result = findContainsProperties("population", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulation :
     * Retourne les éléments trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulation(Population... v) throws TopiaException {
        List<E> results = findAllContainsProperties("population", Arrays.asList(v));
        return results;
    }


} //SpeciesDAOAbstract<E extends Species>
