package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class SpeciesAbstract extends TopiaEntityAbstract implements Species {

    private String name;
    private String scientificName;
    private String codeRubbin;
    private int codeCEE;
    private boolean ageGroupType;
    private String comment;
    public Collection<TargetSpecies> metierSeasonInfoTargetSpecies;
    public Collection<Population> population;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Species.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Species.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "scientificName", String.class, scientificName);
        visitor.visit(this, "codeRubbin", String.class, codeRubbin);
        visitor.visit(this, "codeCEE", int.class, codeCEE);
        visitor.visit(this, "ageGroupType", boolean.class, ageGroupType);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "metierSeasonInfoTargetSpecies", java.util.Collection.class, TargetSpecies.class, metierSeasonInfoTargetSpecies);
        visitor.visit(this, "population", Collection.class, Population.class, population);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<TargetSpecies> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(TargetSpecies.class);
            List<TargetSpecies> findAllByProperties = dao.findAllByProperties("species", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getPopulation() != null) {
              tmp.addAll(getPopulation());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setScientificName :
     * @param value 
     */

    public void setScientificName(String value) {
        String _oldValue = this.scientificName;
        fireOnPreWrite("scientificName", _oldValue, value);
        this.scientificName = value;
        fireOnPostWrite("scientificName", _oldValue, value);
}

    /**
     * getScientificName :
     * @return String 
     */

    public String getScientificName() {
        fireOnPreRead("scientificName", scientificName);
        String result = this.scientificName;
        fireOnPostRead("scientificName", scientificName);
        return result;
}

    /**
     * setCodeRubbin :
     * @param value 
     */

    public void setCodeRubbin(String value) {
        String _oldValue = this.codeRubbin;
        fireOnPreWrite("codeRubbin", _oldValue, value);
        this.codeRubbin = value;
        fireOnPostWrite("codeRubbin", _oldValue, value);
}

    /**
     * getCodeRubbin :
     * @return String 
     */

    public String getCodeRubbin() {
        fireOnPreRead("codeRubbin", codeRubbin);
        String result = this.codeRubbin;
        fireOnPostRead("codeRubbin", codeRubbin);
        return result;
}

    /**
     * setCodeCEE :
     * @param value 
     */

    public void setCodeCEE(int value) {
        int _oldValue = this.codeCEE;
        fireOnPreWrite("codeCEE", _oldValue, value);
        this.codeCEE = value;
        fireOnPostWrite("codeCEE", _oldValue, value);
}

    /**
     * getCodeCEE :
     * @return int 
     */

    public int getCodeCEE() {
        fireOnPreRead("codeCEE", codeCEE);
        int result = this.codeCEE;
        fireOnPostRead("codeCEE", codeCEE);
        return result;
}

    /**
     * setAgeGroupType :
     * @param value 
     */

    public void setAgeGroupType(boolean value) {
        boolean _oldValue = this.ageGroupType;
        fireOnPreWrite("ageGroupType", _oldValue, value);
        this.ageGroupType = value;
        fireOnPostWrite("ageGroupType", _oldValue, value);
}

    /**
     * getAgeGroupType :
     * @return boolean 
     */

    public boolean getAgeGroupType() {
        fireOnPreRead("ageGroupType", ageGroupType);
        boolean result = this.ageGroupType;
        fireOnPostRead("ageGroupType", ageGroupType);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * addPopulation :
     * @param population 
     */

    public void addPopulation(Population population) {    
        fireOnPreWrite("population", null, population);
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        population.setSpecies(this);
        this.population.add(population);
        fireOnPostWrite("population", this.population.size(), null, population);
}

    /**
     * addAllPopulation :
     * @param values 
     */

    public void addAllPopulation(Collection<Population> values) {
        if (values == null) {
            return;
        }
        for (Population item : values) {
            addPopulation(item);
        }
}

    /**
     * getPopulationByTopiaId :
     * @param topiaId 
     * @return Population 
     */

    public Population getPopulationByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(population, topiaId);
 }

    /**
     * setPopulation :
     * @param values 
     */

    public void setPopulation(Collection<Population> values) {
        Collection<Population> _oldValue = population;
        fireOnPreWrite("population", _oldValue, values);
        population = values;
        fireOnPostWrite("population", _oldValue, values);
}

    /**
     * removePopulation :
     * @param value 
     */

    public void removePopulation(Population value) {
        fireOnPreWrite("population", value, null);
        if ((this.population == null) || (!this.population.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setSpecies(null);
        fireOnPostWrite("population", this.population.size()+1, value, null);
}

    /**
     * clearPopulation :
     */

    public void clearPopulation() {
        if (this.population == null) {
            return;
        }
        for (Population item : this.population) {
            item.setSpecies(null);
        }
        Collection<Population> _oldValue = new ArrayList<Population>(this.population);
        fireOnPreWrite("population", _oldValue, this.population);
        this.population.clear();
        fireOnPostWrite("population", _oldValue, this.population);
}

    /**
     * getPopulation :
     * @return Collection<Population> 
     */

    public Collection<Population> getPopulation() {
        return population;
}

    /**
     * sizePopulation :
     * @return int 
     */

    public int sizePopulation() {
        if (population == null) {
            return 0;
        }
        return population.size();
}

    /**
     * isPopulationEmpty :
     * @return boolean 
     */

    public boolean isPopulationEmpty() {
        int size = sizePopulation();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("scientificName", this.scientificName).
            append("codeRubbin", this.codeRubbin).
            append("codeCEE", this.codeCEE).
            append("ageGroupType", this.ageGroupType).
            append("comment", this.comment).
         toString();
        return result;
}


} //SpeciesAbstract
